/*
  Copyright Kitware, Inc.

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

      https://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/
#ifndef CASTXML_UTILS_H
#define CASTXML_UTILS_H

#include <string>

/// findResourceDir - Call from main() to find resources
/// relative to the executable.  On success returns true.
/// On failure returns false and stores a message in the stream.
bool findResourceDir(char const* argv0, std::ostream& error);

/// getResourceDir - Get resource directory found at startup
std::string getResourceDir();

/// getClangResourceDir - Get Clang resource directory found at startup
std::string getClangResourceDir();

/// getVersionString - Get the CastXML version string
std::string getVersionString();

/// getVersionMajor - Get CastXML major version.
unsigned int getVersionMajor();

/// getVersionMinor - Get CastXML minor version.
unsigned int getVersionMinor();

/// getVersionPatch - Get CastXML patch version.
unsigned int getVersionPatch();

/// runCommand - Run a given command line and capture the output.
bool runCommand(int argc, char const* const* argv, int& ret, std::string& out,
                std::string& err, std::string& msg,
                std::string* maybeTmpDir = nullptr);

/// suppressInteractiveErrors - Disable Windows error dialog popups
void suppressInteractiveErrors();

/// encodeXML - Convert character string to XML representation
std::string encodeXML(std::string const& in, bool cdata = false);

/// stringReplace - Replace all occurrences of an 'in' string with 'out'.
std::string stringReplace(std::string str, std::string const& in,
                          std::string const& out);

#endif // CASTXML_UTILS_H
