"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.NumberInput = void 0;
const tslib_1 = require("tslib");
const jsx_runtime_1 = require("react/jsx-runtime");
const number_input_1 = tslib_1.__importDefault(require("@patternfly/react-styles/css/components/NumberInput/number-input"));
const react_styles_1 = require("@patternfly/react-styles");
const minus_icon_1 = tslib_1.__importDefault(require('@patternfly/react-icons/dist/js/icons/minus-icon'));
const plus_icon_1 = tslib_1.__importDefault(require('@patternfly/react-icons/dist/js/icons/plus-icon'));
const InputGroup_1 = require("../InputGroup");
const Button_1 = require("../Button");
const helpers_1 = require("../../helpers");
const TextInput_1 = require("../TextInput");
const c_number_input_c_form_control_width_chars_1 = tslib_1.__importDefault(require('@patternfly/react-tokens/dist/js/c_number_input_c_form_control_width_chars'));
const defaultKeyDownHandler = (args) => (event) => {
    if (helpers_1.KeyTypes.ArrowUp === event.key && args.onPlus) {
        event.preventDefault();
        args.onPlus(null, args.inputName);
    }
    if (helpers_1.KeyTypes.ArrowDown === event.key && args.onMinus) {
        event.preventDefault();
        args.onMinus(null, args.inputName);
    }
};
const DEFAULT_VALUE = 0;
const NumberInput = (_a) => {
    var { value = DEFAULT_VALUE, className, widthChars, isDisabled = false, validated = helpers_1.ValidatedOptions.default, onMinus = () => { }, onChange, onBlur, onPlus = () => { }, unit, unitPosition = 'after', min, max, inputName, inputAriaLabel = 'Input', minusBtnAriaLabel = 'Minus', plusBtnAriaLabel = 'Plus', inputProps, minusBtnProps, plusBtnProps } = _a, props = tslib_1.__rest(_a, ["value", "className", "widthChars", "isDisabled", "validated", "onMinus", "onChange", "onBlur", "onPlus", "unit", "unitPosition", "min", "max", "inputName", "inputAriaLabel", "minusBtnAriaLabel", "plusBtnAriaLabel", "inputProps", "minusBtnProps", "plusBtnProps"]);
    const numberInputUnit = (0, jsx_runtime_1.jsx)("div", { className: (0, react_styles_1.css)(number_input_1.default.numberInputUnit), children: unit });
    const keyDownHandler = inputProps && inputProps.onKeyDown ? inputProps.onKeyDown : defaultKeyDownHandler({ inputName, onMinus, onPlus });
    const handleBlur = (event) => {
        event.target.value = Number(event.target.value).toString();
        if (onChange) {
            onChange(event);
        }
        if (onBlur) {
            onBlur(event);
        }
    };
    return ((0, jsx_runtime_1.jsxs)("div", Object.assign({ 
        // TODO: Update with issue #9978. Removed "validated !== 'default' && styles.modifiers.status" from classname to get build to work
        className: (0, react_styles_1.css)(number_input_1.default.numberInput, className) }, (widthChars && {
        style: Object.assign({ [c_number_input_c_form_control_width_chars_1.default.name]: widthChars }, props.style)
    }), props, { children: [unit && unitPosition === 'before' && numberInputUnit, (0, jsx_runtime_1.jsxs)(InputGroup_1.InputGroup, { children: [(0, jsx_runtime_1.jsx)(InputGroup_1.InputGroupItem, { children: (0, jsx_runtime_1.jsx)(Button_1.Button, Object.assign({ variant: "control", "aria-label": minusBtnAriaLabel, isDisabled: isDisabled || (typeof value === 'number' ? value : DEFAULT_VALUE) <= min, onClick: (evt) => onMinus(evt, inputName), icon: (0, jsx_runtime_1.jsx)("span", { className: (0, react_styles_1.css)(number_input_1.default.numberInputIcon), children: (0, jsx_runtime_1.jsx)(minus_icon_1.default, {}) }) }, minusBtnProps)) }), (0, jsx_runtime_1.jsx)(InputGroup_1.InputGroupItem, { children: (0, jsx_runtime_1.jsx)(TextInput_1.TextInput, Object.assign({}, inputProps, { type: "number", value: value, name: inputName, "aria-label": inputAriaLabel }, (isDisabled && { isDisabled }), (onChange && { onChange: (event, _value) => onChange(event) }), { onBlur: handleBlur }, (!onChange && { readOnlyVariant: 'default' }), { onKeyDown: keyDownHandler, validated: validated })) }), (0, jsx_runtime_1.jsx)(InputGroup_1.InputGroupItem, { children: (0, jsx_runtime_1.jsx)(Button_1.Button, Object.assign({ variant: "control", "aria-label": plusBtnAriaLabel, isDisabled: isDisabled || (typeof value === 'number' ? value : DEFAULT_VALUE) >= max, onClick: (evt) => onPlus(evt, inputName), icon: (0, jsx_runtime_1.jsx)("span", { className: (0, react_styles_1.css)(number_input_1.default.numberInputIcon), children: (0, jsx_runtime_1.jsx)(plus_icon_1.default, {}) }) }, plusBtnProps)) })] }), unit && unitPosition === 'after' && numberInputUnit] })));
};
exports.NumberInput = NumberInput;
exports.NumberInput.displayName = 'NumberInput';
//# sourceMappingURL=NumberInput.js.map