# Copyright © The Debusine Developers
# See the AUTHORS file at the top-level directory of this distribution
#
# This file is part of Debusine. It is subject to the license terms
# in the LICENSE file found in the top-level directory of this
# distribution. No part of Debusine, including this file, may be copied,
# modified, propagated, or distributed except according to the terms
# contained in the LICENSE file.

"""Template tag library for users."""

from django import template
from django.utils.html import format_html

from debusine.db.context import context
from debusine.db.models import User

register = template.Library()


@register.filter
def user_link(user: User) -> str:
    """Return a link in an authenticated request, otherwise the name."""
    if user.can_display(context.user):
        return format_html('<a href="{}">{}</a>', user.get_absolute_url(), user)
    else:
        return str(user)
