# Tutorial #

Documentación completa de los métodos: [Documentación de la API de `fpdf.FPDF`](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF)

## Tutorial 1 - Ejemplo básico ##

Empecemos con el ejemplo clásico: 

```python
{% include "../tutorial/tuto1.py" %}
```

[PDF resultante](https://github.com/py-pdf/fpdf2/raw/master/tutorial/tuto1.pdf)

Luego de incluir la biblioteca, creamos un objeto `FPDF`. El constructor 
[FPDF](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF) es usado aquí con los valores predeterminados: 
Las páginas están en A4 vertical y la unidad de medida es milímetros.
Podría haberse especificado explícitamente con: 

```python
pdf = FPDF(orientation="P", unit="mm", format="A4")
```

Es posible configurar el PDF en modo horizontal (`L`) o usar otros formatos de página 
como carta (`Letter`) y oficio (`Legal`) y unidades de medida (`pt`, `cm`, `in`).

Por el momento no hay una página, entonces tenemos que agregar una con 
[add_page](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF.add_page). El origen es la esquina superior izquierda y la 
posición actual está ubicada por defecto a 1 cm de los bordes; los márgenes pueden 
ser cambiados con [set_margins](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF.set_margins). 

Antes de que podamos imprimir texto, es obligatorio seleccionar una fuente con 
[set_font](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF.set_font), de lo contrario, el documento sería inválido. 
Elegimos helvetica en negrita 16: 

```python
pdf.set_font('Helvetica', style='B', size=16)
```

Podríamos haber especificado cursiva con `I`, subrayado con `U` o fuente regular 
con una cadena de texto vacía (o cualquier combinación). Nota que el tamaño de la fuente es dado en 
puntos, no en milímetros (u otra unidad de medida del usuario); ésta es la única excepción. 
Las otras fuentes estándar son `Times`, `Courier`, `Symbol` y `ZapfDingbats`. 

Podemos ahora imprimir una celda con [cell](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF.cell). Una celda es un área 
rectangular, posiblemente enmarcada, que contiene algún texto. Se imprime en la posición 
actual. Especificamos sus dimensiones, su texto (centrado o alineado), si los bordes 
deberían ser dibujados, y a donde la posición actual se mueve después (a la derecha, 
abajo o al principio de la próxima linea). Para agregar un marco, haremos esto: 

```python
pdf.cell(40, 10, '¡Hola mundo!', 1)
```

Para agregar una nueva celda próxima a él, con texto centrado y luego ir a la siguiente línea, 
haríamos: 

```python
pdf.cell(60, 10, 'Hecho con FPDF.', new_x="LMARGIN", new_y="NEXT", align='C')
```

**Nota**: el salto de línea puede hacerse también con [ln](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF.ln). Este 
método permite especificar adicionalmente la altura del salto. 

Finalmente, el documento es cerrado y guardado en la ruta provista usando 
[output](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF.output). Sin ningún parámetro provisto, `output()` 
devuelve el búfer `bytearray` del PDF.

## Tutorial 2 - Encabezado, pie de página, salto de página e imagen ##

Aquí hay un ejemplo de dos páginas con encabezado, pie de página y logo: 

```python
{% include "../tutorial/tuto2.py" %}
```

[PDF resultante](https://github.com/py-pdf/fpdf2/raw/master/tutorial/tuto2.pdf)

Este ejemplo hace uso de los métodos [header](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF.header) y 
[footer](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF.footer) para procesar encabezados y pies de página. Estos 
son invocados automáticamente. Ellos ya existen en la clase FPDF pero no hacen nada, 
por lo tanto tenemos que extender la clase y sobreescribirlos. 

El logo es impreso con el método [image](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF.image) especificando 
su esquina superior izquierda y su ancho. La altura es calculada automáticamente para 
respetar las proporciones de la imagen. 

Para imprimir el número de página, un valor nulo es pasado como ancho de celda. Esto significa 
que la celda deberá ser extendida hasta el margen derecho de la página; es útil para 
centrar texto. El número de página actual es devuelto por el método 
[page_no](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF.page_no); respecto 
al número total de páginas, éste es obtenido mediante el valor especial `{nb}` 
que será sustituido al cerrar el documento (este valor especial puede ser cambiado con 
[alias_nb_pages()](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF.alias_nb_pages)). 
Nota el uso del método [set_y](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF.set_y) que permite establecer 
la posición en una ubicación absoluta en la página, empezando desde arriba o desde 
abajo. 

Otra característica interesante es usada aquí: el salto de página automático. Tan pronto 
como una celda cruzaría el límite de la página (por defecto a 2 centímetros del borde 
inferior), un salto es realizado y la fuente es restaurada. Aunque el encabezado y 
pie de página tienen su propia fuente (`helvetica`), el cuerpo continúa en `Times`. 
Este mecanismo de restauración automática también se aplica a los colores y al ancho de la línea. 
El límite que dispara los saltos de página puede establecerse con 
[set_auto_page_break](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF.set_auto_page_break).


## Tutorial 3 - Saltos de línea y colores ##

Continuemos con un ejemplo que imprime párrafos justificados. También 
ilustra el uso de colores.

```python
{% include "../tutorial/tuto3.py" %}
```

[PDF resultante](https://github.com/py-pdf/fpdf2/raw/master/tutorial/tuto3.pdf)

[Texto de Julio Verne](https://github.com/py-pdf/fpdf2/raw/master/tutorial/20k_c1.txt)

El método [get_string_width](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF.get_string_width) permite determinar 
la longitud de una cadena de texto en la fuente actual, usada aquí para calcular la 
posición y el ancho del marco que rodea al título. Los colores son establecidos 
(vía [set_draw_color](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF.set_draw_color), 
[set_fill_color](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF.set_fill_color) y 
[set_text_color](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF.set_text_color)) y el grosor de la línea es establecido 
a 1 mm (contra 0.2 por defecto) con 
[set_line_width](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF.set_line_width). Finalmente, emitimos la celda (el 
último parámetro en `True` para indicar que el fondo debe ser rellenado). 

El método usado para imprimir párrafos es [multi_cell](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF.multi_cell). El texto es justificado por defecto. 
Cada vez que una línea alcanza el extremo derecho de la celda o un caracter de retorno de línea (`\n`) es encontrado, 
un salto de línea es emitido y una nueva celda es automáticamente creada bajo la actual. 
Un salto automático es realizado en la ubicación del espacio o guión suave (`\u00ad`) más cercano antes del límite derecho.
Un guión suave será reemplazado por un guión normal cuando un salto de línea se dispara, e ignorado en cualquier otro caso.

Dos propiedades del documento son definidas: el título 
([set_title](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF.set_title)) y el autor 
([set_author](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF.set_author)). Las propiedades pueden ser vistas de dos formas. 
La primera es abrir el documento directamente con Acrobat Reader, ir al menú Archivo 
y elegir la opción Propiedades del Documento. La segunda, también disponible desde el 
complemento, es hacer clic derecho y seleccionar Propiedades del documento.

## Tutorial 4 - Múltiples columnas ##

Este ejemplo es una variante del anterior, mostrando cómo poner el texto en múltiples columnas.

```python
{% include "../tutorial/tuto4.py" %}
```

[PDF resultante](https://github.com/py-pdf/fpdf2/raw/master/tutorial/tuto4.pdf)

[Texto de Julio Verne](https://github.com/py-pdf/fpdf2/raw/master/tutorial/20k_c1.txt)

La diferencia clave respecto al tutorial anterior es el uso del 
método [`text_columns`](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF.text_column). 
Este recoge todo el texto, posiblemente en incrementos, y lo distribuye entre el número de columnas solicitadas, insertando automáticamente saltos de página según sea necesario. Nota que mientras la instancia de `TextColumns` está activa como gestor de contexto, los estilos de texto y otras propiedades de la fuente pueden cambiarse. Estos cambios estarán contenidos en el contexto. Una vez se cierre, la configuración previa será reestablecida.


## Tutorial 5 - Creando tablas ##

Este tutorial explicará cómo crear dos tablas diferentes,
 para demostrar lo que se puede lograr con algunos ajustes simples.

```python
{% include "../tutorial/tuto5.py" %}
```

[PDF resultante](https://github.com/py-pdf/fpdf2/raw/master/tutorial/tuto5.pdf) -
[Archivo de texto con países](https://github.com/py-pdf/fpdf2/raw/master/tutorial/countries.txt)

El primer ejemplo es alcanzado de la forma más básica posible, alimentando datos a [`FPDF.table()`](https://py-pdf.github.io/fpdf2/Tables.html). El resultado es rudimentario pero muy rápido de obtener.

La segunda tabla trae algunas mejoras: colores, ancho de tabla limitado, altura de línea reducida,
 títulos centrados, columnas con anchos personalizados, figuras alineadas a la derecha...
 Aún más, las líneas horizontales han sido removidas.
 Esto se hizo escogiendo un `borders_layout` entre los valores disponibles:
 [`TableBordersLayout`](https://py-pdf.github.io/fpdf2/fpdf/enums.html#fpdf.enums.TableBordersLayout).

## Tutorial 6 - Creando enlaces y combinando estilos de texto ##

Este tutorial explicará varias formas de insertar enlaces dentro de un documento pdf, 
al igual que cómo agregar enlaces a recursos externos.

También mostrará muchas formas en que podemos usar los diferentes estilos de texto 
(negrita, cursiva, subrayado) dentro del mismo texto.

```python
{% include "../tutorial/tuto6.py" %}
```

[PDF resultante](https://github.com/py-pdf/fpdf2/raw/master/tutorial/tuto6.pdf) -
[Logo de fpdf2](https://py-pdf.github.io/fpdf2/fpdf2-logo.png)

El nuevo método mostrado aquí para imprimir texto es
 [write()](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF.write)
. Es muy similar a
 [multi_cell()](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF.multi_cell)
, siendo las diferencias clave:
 
 - El final de línea está en el margen derecho y la siguiente línea comienza en el margen
  izquierdo.
 - La posición actual se desplaza al final del texto.

El método por tanto nos permite escribir un trozo de texto, alterar el estilo de la fuente,
 y continuar desde el lugar exacto donde quedamos.
Por otro lado, su principal desventaja es que no podemos justificar el texto como
 hacemos con el
 método
 [multi_cell()](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF.multi_cell).

En la primera página del ejemplo usamos
 [write()](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF.write)
 para este propósito. El comienzo de la oración está escrito usando texto en estilo
 regular, luego usando el método
 [set_font()](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF.set_font)
 cambiamos a subrayado y terminamos la oración.

Para agregar un enlace interno apuntando a la segunda página, usamos el método
 [add_link()](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF.add_link)
, el cual crea un área clicable a la que nombramos "link" que redirige a
 otro lugar dentro del documento.

Para crear un enlace externo usando una imagen, usamos
 [image()](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF.image)
. El método tiene la
 opción de recibir un enlace como uno de sus argumentos. El enlace puede ser tanto interno
 como externo.

Como alternativa, otra opción para cambiar el estilo de fuente y agregar enlaces es
 usar el método `write_html()`. Este es un analizador de html que permite agregar texto,
 cambiar el estilo de fuente y agregar enlaces usando html.

## Tutorial 7 - Creando documentos PDF/A ##

_Nuevo en [:octicons-tag-24: 2.8.3](https://github.com/py-pdf/fpdf2/blob/master/CHANGELOG.md)_

### Estándares PDF/A ###

<b>PDF/A-1</b> usa PDF versión 1.4. Todos los recursos (imágenes, gráficos, fuentes) deben ser incrustados en el documento. El manejo del color debe ser preciso y especificado de forma independiente de la plataforma con perfiles ICC y los metadatos del documento deben darse con metadatos XMP.

<b>PDF/A-2</b> usa PDF versión 1.7. Permite compresión con JPEG2000, elementos transparentes, fuentes open type y firmas digitales.

La única adición en <b>PDF/A-3</b> es la posibilidad de incrustar cualquier archivo posible.

### Clases de Conformidad ###

El nivel A (accesible) incluye todos los requerimientos del estándar, incluidos el mapeo de la estructura de contenido y el orden correcto de lectura del contenido del documento. El contenido de texto debe ser extraíble, y la estructura debe reflejar la secuencia de lectura natural.

El nivel B (básico) garantiza una reproducibilidad visual clara del contenido. El nivel B es generalmente más fácil de generar que el nivel A, pero no asegura en un ciento por ciento la extracción del texto o la buscabilidad. El reúso sin complicaciones del contenido no está necesariamente garantizado.

Para lograr esto, aquí hay un pequeño ejemplo:

```python
{% include "../tutorial/tuto7.py" %}
```

[PDF resultante: tuto7.pdf](https://github.com/py-pdf/fpdf2/raw/master/tutorial/tuto7.pdf)

Herramientas como [VeraPDF](https://verapdf.org/) pueden verificar la conformidad de los documentos PDF producidos:

    verapdf --format text -v tutorial/tuto7.pdf

Produce:

    PASS fpdf2/tutorial/tuto7.pdf 3b
