/**
 * FreeRDP: A Remote Desktop Protocol Implementation
 * RDP Extensions
 *
 * Copyright 2010-2011 Vic Lee
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef FREERDP_EXTENSION_H
#define FREERDP_EXTENSION_H

#include <freerdp/api.h>
#include <freerdp/types.h>

#define FREERDP_EXT_EXPORT_FUNC_NAME "FreeRDPExtensionEntry"

#ifdef __cplusplus
extern "C"
{
#endif

	typedef struct rdp_ext_plugin rdpExtPlugin;

	struct rdp_ext_plugin
	{
		void* ext;
		WINPR_ATTR_NODISCARD int (*init)(rdpExtPlugin* plugin, freerdp* instance);
		WINPR_ATTR_NODISCARD int (*uninit)(rdpExtPlugin* plugin, freerdp* instance);
	};

	typedef UINT32(FREERDP_CC* PFREERDP_EXTENSION_HOOK)(rdpExtPlugin* plugin, freerdp* instance);

	typedef UINT32(FREERDP_CC* PREGISTEREXTENSION)(rdpExtPlugin* plugin);
	typedef UINT32(FREERDP_CC* PREGISTERPRECONNECTHOOK)(rdpExtPlugin* plugin,
	                                                    PFREERDP_EXTENSION_HOOK hook);
	typedef UINT32(FREERDP_CC* PREGISTERPOSTCONNECTHOOK)(rdpExtPlugin* plugin,
	                                                     PFREERDP_EXTENSION_HOOK hook);

	typedef struct
	{
		void* ext; /* Reference to internal instance */
		WINPR_ATTR_NODISCARD PREGISTEREXTENSION pRegisterExtension;
		WINPR_ATTR_NODISCARD PREGISTERPRECONNECTHOOK pRegisterPreConnectHook;
		WINPR_ATTR_NODISCARD PREGISTERPOSTCONNECTHOOK pRegisterPostConnectHook;
		void* data;
	} FREERDP_EXTENSION_ENTRY_POINTS;
	typedef FREERDP_EXTENSION_ENTRY_POINTS* PFREERDP_EXTENSION_ENTRY_POINTS;

	typedef int(FREERDP_CC* PFREERDP_EXTENSION_ENTRY)(PFREERDP_EXTENSION_ENTRY_POINTS pEntryPoints);

#ifdef __cplusplus
}
#endif

#endif /* FREERDP_EXTENSION_H */
