//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/datalake-store/armdatalakestore"
	"net/http"
	"net/url"
	"reflect"
	"regexp"
)

// TrustedIDProvidersServer is a fake server for instances of the armdatalakestore.TrustedIDProvidersClient type.
type TrustedIDProvidersServer struct {
	// CreateOrUpdate is the fake for method TrustedIDProvidersClient.CreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK
	CreateOrUpdate func(ctx context.Context, resourceGroupName string, accountName string, trustedIDProviderName string, parameters armdatalakestore.CreateOrUpdateTrustedIDProviderParameters, options *armdatalakestore.TrustedIDProvidersClientCreateOrUpdateOptions) (resp azfake.Responder[armdatalakestore.TrustedIDProvidersClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method TrustedIDProvidersClient.Delete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	Delete func(ctx context.Context, resourceGroupName string, accountName string, trustedIDProviderName string, options *armdatalakestore.TrustedIDProvidersClientDeleteOptions) (resp azfake.Responder[armdatalakestore.TrustedIDProvidersClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method TrustedIDProvidersClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, accountName string, trustedIDProviderName string, options *armdatalakestore.TrustedIDProvidersClientGetOptions) (resp azfake.Responder[armdatalakestore.TrustedIDProvidersClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByAccountPager is the fake for method TrustedIDProvidersClient.NewListByAccountPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByAccountPager func(resourceGroupName string, accountName string, options *armdatalakestore.TrustedIDProvidersClientListByAccountOptions) (resp azfake.PagerResponder[armdatalakestore.TrustedIDProvidersClientListByAccountResponse])

	// Update is the fake for method TrustedIDProvidersClient.Update
	// HTTP status codes to indicate success: http.StatusOK
	Update func(ctx context.Context, resourceGroupName string, accountName string, trustedIDProviderName string, options *armdatalakestore.TrustedIDProvidersClientUpdateOptions) (resp azfake.Responder[armdatalakestore.TrustedIDProvidersClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewTrustedIDProvidersServerTransport creates a new instance of TrustedIDProvidersServerTransport with the provided implementation.
// The returned TrustedIDProvidersServerTransport instance is connected to an instance of armdatalakestore.TrustedIDProvidersClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewTrustedIDProvidersServerTransport(srv *TrustedIDProvidersServer) *TrustedIDProvidersServerTransport {
	return &TrustedIDProvidersServerTransport{
		srv:                   srv,
		newListByAccountPager: newTracker[azfake.PagerResponder[armdatalakestore.TrustedIDProvidersClientListByAccountResponse]](),
	}
}

// TrustedIDProvidersServerTransport connects instances of armdatalakestore.TrustedIDProvidersClient to instances of TrustedIDProvidersServer.
// Don't use this type directly, use NewTrustedIDProvidersServerTransport instead.
type TrustedIDProvidersServerTransport struct {
	srv                   *TrustedIDProvidersServer
	newListByAccountPager *tracker[azfake.PagerResponder[armdatalakestore.TrustedIDProvidersClientListByAccountResponse]]
}

// Do implements the policy.Transporter interface for TrustedIDProvidersServerTransport.
func (t *TrustedIDProvidersServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "TrustedIDProvidersClient.CreateOrUpdate":
		resp, err = t.dispatchCreateOrUpdate(req)
	case "TrustedIDProvidersClient.Delete":
		resp, err = t.dispatchDelete(req)
	case "TrustedIDProvidersClient.Get":
		resp, err = t.dispatchGet(req)
	case "TrustedIDProvidersClient.NewListByAccountPager":
		resp, err = t.dispatchNewListByAccountPager(req)
	case "TrustedIDProvidersClient.Update":
		resp, err = t.dispatchUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (t *TrustedIDProvidersServerTransport) dispatchCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if t.srv.CreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdate not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataLakeStore/accounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/trustedIdProviders/(?P<trustedIdProviderName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armdatalakestore.CreateOrUpdateTrustedIDProviderParameters](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	trustedIDProviderNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("trustedIdProviderName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := t.srv.CreateOrUpdate(req.Context(), resourceGroupNameParam, accountNameParam, trustedIDProviderNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).TrustedIDProvider, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (t *TrustedIDProvidersServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if t.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataLakeStore/accounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/trustedIdProviders/(?P<trustedIdProviderName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	trustedIDProviderNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("trustedIdProviderName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := t.srv.Delete(req.Context(), resourceGroupNameParam, accountNameParam, trustedIDProviderNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (t *TrustedIDProvidersServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if t.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataLakeStore/accounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/trustedIdProviders/(?P<trustedIdProviderName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	trustedIDProviderNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("trustedIdProviderName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := t.srv.Get(req.Context(), resourceGroupNameParam, accountNameParam, trustedIDProviderNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).TrustedIDProvider, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (t *TrustedIDProvidersServerTransport) dispatchNewListByAccountPager(req *http.Request) (*http.Response, error) {
	if t.srv.NewListByAccountPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByAccountPager not implemented")}
	}
	newListByAccountPager := t.newListByAccountPager.get(req)
	if newListByAccountPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataLakeStore/accounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/trustedIdProviders`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		resp := t.srv.NewListByAccountPager(resourceGroupNameParam, accountNameParam, nil)
		newListByAccountPager = &resp
		t.newListByAccountPager.add(req, newListByAccountPager)
		server.PagerResponderInjectNextLinks(newListByAccountPager, req, func(page *armdatalakestore.TrustedIDProvidersClientListByAccountResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByAccountPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		t.newListByAccountPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByAccountPager) {
		t.newListByAccountPager.remove(req)
	}
	return resp, nil
}

func (t *TrustedIDProvidersServerTransport) dispatchUpdate(req *http.Request) (*http.Response, error) {
	if t.srv.Update == nil {
		return nil, &nonRetriableError{errors.New("fake for method Update not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataLakeStore/accounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/trustedIdProviders/(?P<trustedIdProviderName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armdatalakestore.UpdateTrustedIDProviderParameters](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	trustedIDProviderNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("trustedIdProviderName")])
	if err != nil {
		return nil, err
	}
	var options *armdatalakestore.TrustedIDProvidersClientUpdateOptions
	if !reflect.ValueOf(body).IsZero() {
		options = &armdatalakestore.TrustedIDProvidersClientUpdateOptions{
			Parameters: &body,
		}
	}
	respr, errRespr := t.srv.Update(req.Context(), resourceGroupNameParam, accountNameParam, trustedIDProviderNameParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).TrustedIDProvider, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
