# getDirectoryToWatchFailedLookupLocation

Determines whether to watch given failed lookup location (file that didnt exist) when resolving module.
It also determines the directory to watch and whether to watch it recursively or not.

## Testing for Unc root: //vda1cs4850/

## RootDirForResolution: //vda1cs4850/

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/somefile.d.ts                                                                               |                                                                                                          |           |
| //vda1cs4850/dir/somefile.d.ts                                                                           |                                                                                                          |           |
| //vda1cs4850/dir/subdir/somefile.d.ts                                                                    |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/somefile.d.ts                                                                  |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/dir/somefile.d.ts                                                              |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/folderAtRoot/dir/subdir                                                                     | true      |
| //vda1cs4850/folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/folder1/dir/somefile.d.ts                                                      | //vda1cs4850/folderAtRoot/folder1/dir                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/folderAtRoot/folder1/dir                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/users/somefile.d.ts                                                                         |                                                                                                          |           |
| //vda1cs4850/users/dir/somefile.d.ts                                                                     |                                                                                                          |           |
| //vda1cs4850/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/users/dir/subdir                                                                            | true      |
| //vda1cs4850/users/username/somefile.d.ts                                                                |                                                                                                          |           |
| //vda1cs4850/users/username/dir/somefile.d.ts                                                            | //vda1cs4850/users/username/dir                                                                          | true      |
| //vda1cs4850/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/users/username/dir                                                                          | true      |
| //vda1cs4850/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/dir/somefile.d.ts                                               | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/user/somefile.d.ts                                                                          |                                                                                                          |           |
| //vda1cs4850/user/dir/somefile.d.ts                                                                      |                                                                                                          |           |
| //vda1cs4850/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/user/dir/subdir                                                                             | true      |
| //vda1cs4850/user/username/somefile.d.ts                                                                 |                                                                                                          |           |
| //vda1cs4850/user/username/dir/somefile.d.ts                                                             | //vda1cs4850/user/username/dir                                                                           | true      |
| //vda1cs4850/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/user/username/dir                                                                           | true      |
| //vda1cs4850/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/usr/somefile.d.ts                                                                           |                                                                                                          |           |
| //vda1cs4850/usr/dir/somefile.d.ts                                                                       |                                                                                                          |           |
| //vda1cs4850/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/usr/dir/subdir                                                                              | true      |
| //vda1cs4850/usr/username/somefile.d.ts                                                                  |                                                                                                          |           |
| //vda1cs4850/usr/username/dir/somefile.d.ts                                                              | //vda1cs4850/usr/username/dir                                                                            | true      |
| //vda1cs4850/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/usr/username/dir                                                                            | true      |
| //vda1cs4850/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/home/somefile.d.ts                                                                          |                                                                                                          |           |
| //vda1cs4850/home/dir/somefile.d.ts                                                                      |                                                                                                          |           |
| //vda1cs4850/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/home/dir/subdir                                                                             | true      |
| //vda1cs4850/home/username/somefile.d.ts                                                                 |                                                                                                          |           |
| //vda1cs4850/home/username/dir/somefile.d.ts                                                             | //vda1cs4850/home/username/dir                                                                           | true      |
| //vda1cs4850/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/home/username/dir                                                                           | true      |
| //vda1cs4850/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |

## RootDirForResolution: //vda1cs4850/folderAtRoot

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/somefile.d.ts                                                                               |                                                                                                          |           |
| //vda1cs4850/dir/somefile.d.ts                                                                           |                                                                                                          |           |
| //vda1cs4850/dir/subdir/somefile.d.ts                                                                    |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/somefile.d.ts                                                                  |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/dir/somefile.d.ts                                                              |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/folderAtRoot/dir/subdir                                                                     | true      |
| //vda1cs4850/folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/folder1/dir/somefile.d.ts                                                      | //vda1cs4850/folderAtRoot/folder1/dir                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/folderAtRoot/folder1/dir                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/users/somefile.d.ts                                                                         |                                                                                                          |           |
| //vda1cs4850/users/dir/somefile.d.ts                                                                     |                                                                                                          |           |
| //vda1cs4850/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/users/dir/subdir                                                                            | true      |
| //vda1cs4850/users/username/somefile.d.ts                                                                |                                                                                                          |           |
| //vda1cs4850/users/username/dir/somefile.d.ts                                                            | //vda1cs4850/users/username/dir                                                                          | true      |
| //vda1cs4850/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/users/username/dir                                                                          | true      |
| //vda1cs4850/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/dir/somefile.d.ts                                               | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/user/somefile.d.ts                                                                          |                                                                                                          |           |
| //vda1cs4850/user/dir/somefile.d.ts                                                                      |                                                                                                          |           |
| //vda1cs4850/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/user/dir/subdir                                                                             | true      |
| //vda1cs4850/user/username/somefile.d.ts                                                                 |                                                                                                          |           |
| //vda1cs4850/user/username/dir/somefile.d.ts                                                             | //vda1cs4850/user/username/dir                                                                           | true      |
| //vda1cs4850/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/user/username/dir                                                                           | true      |
| //vda1cs4850/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/usr/somefile.d.ts                                                                           |                                                                                                          |           |
| //vda1cs4850/usr/dir/somefile.d.ts                                                                       |                                                                                                          |           |
| //vda1cs4850/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/usr/dir/subdir                                                                              | true      |
| //vda1cs4850/usr/username/somefile.d.ts                                                                  |                                                                                                          |           |
| //vda1cs4850/usr/username/dir/somefile.d.ts                                                              | //vda1cs4850/usr/username/dir                                                                            | true      |
| //vda1cs4850/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/usr/username/dir                                                                            | true      |
| //vda1cs4850/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/home/somefile.d.ts                                                                          |                                                                                                          |           |
| //vda1cs4850/home/dir/somefile.d.ts                                                                      |                                                                                                          |           |
| //vda1cs4850/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/home/dir/subdir                                                                             | true      |
| //vda1cs4850/home/username/somefile.d.ts                                                                 |                                                                                                          |           |
| //vda1cs4850/home/username/dir/somefile.d.ts                                                             | //vda1cs4850/home/username/dir                                                                           | true      |
| //vda1cs4850/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/home/username/dir                                                                           | true      |
| //vda1cs4850/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |

## RootDirForResolution: //vda1cs4850/folderAtRoot/folder1

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/somefile.d.ts                                                                               |                                                                                                          |           |
| //vda1cs4850/dir/somefile.d.ts                                                                           |                                                                                                          |           |
| //vda1cs4850/dir/subdir/somefile.d.ts                                                                    |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/somefile.d.ts                                                                  |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/dir/somefile.d.ts                                                              |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/folderAtRoot/dir/subdir                                                                     | true      |
| //vda1cs4850/folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/folder1/dir/somefile.d.ts                                                      | //vda1cs4850/folderAtRoot/folder1/dir                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/folderAtRoot/folder1/dir                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/users/somefile.d.ts                                                                         |                                                                                                          |           |
| //vda1cs4850/users/dir/somefile.d.ts                                                                     |                                                                                                          |           |
| //vda1cs4850/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/users/dir/subdir                                                                            | true      |
| //vda1cs4850/users/username/somefile.d.ts                                                                |                                                                                                          |           |
| //vda1cs4850/users/username/dir/somefile.d.ts                                                            | //vda1cs4850/users/username/dir                                                                          | true      |
| //vda1cs4850/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/users/username/dir                                                                          | true      |
| //vda1cs4850/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/dir/somefile.d.ts                                               | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/user/somefile.d.ts                                                                          |                                                                                                          |           |
| //vda1cs4850/user/dir/somefile.d.ts                                                                      |                                                                                                          |           |
| //vda1cs4850/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/user/dir/subdir                                                                             | true      |
| //vda1cs4850/user/username/somefile.d.ts                                                                 |                                                                                                          |           |
| //vda1cs4850/user/username/dir/somefile.d.ts                                                             | //vda1cs4850/user/username/dir                                                                           | true      |
| //vda1cs4850/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/user/username/dir                                                                           | true      |
| //vda1cs4850/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/usr/somefile.d.ts                                                                           |                                                                                                          |           |
| //vda1cs4850/usr/dir/somefile.d.ts                                                                       |                                                                                                          |           |
| //vda1cs4850/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/usr/dir/subdir                                                                              | true      |
| //vda1cs4850/usr/username/somefile.d.ts                                                                  |                                                                                                          |           |
| //vda1cs4850/usr/username/dir/somefile.d.ts                                                              | //vda1cs4850/usr/username/dir                                                                            | true      |
| //vda1cs4850/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/usr/username/dir                                                                            | true      |
| //vda1cs4850/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/home/somefile.d.ts                                                                          |                                                                                                          |           |
| //vda1cs4850/home/dir/somefile.d.ts                                                                      |                                                                                                          |           |
| //vda1cs4850/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/home/dir/subdir                                                                             | true      |
| //vda1cs4850/home/username/somefile.d.ts                                                                 |                                                                                                          |           |
| //vda1cs4850/home/username/dir/somefile.d.ts                                                             | //vda1cs4850/home/username/dir                                                                           | true      |
| //vda1cs4850/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/home/username/dir                                                                           | true      |
| //vda1cs4850/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |

## RootDirForResolution: //vda1cs4850/folderAtRoot/folder1/folder2

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/somefile.d.ts                                                                               |                                                                                                          |           |
| //vda1cs4850/dir/somefile.d.ts                                                                           |                                                                                                          |           |
| //vda1cs4850/dir/subdir/somefile.d.ts                                                                    |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/somefile.d.ts                                                                  |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/dir/somefile.d.ts                                                              |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/folderAtRoot/dir/subdir                                                                     | true      |
| //vda1cs4850/folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/folder1/dir/somefile.d.ts                                                      | //vda1cs4850/folderAtRoot/folder1/dir                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/folderAtRoot/folder1/dir                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | false     |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | //vda1cs4850/folderAtRoot/folder1/folder2/dir                                                            | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2/dir                                                            | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3                                                        | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | //vda1cs4850/folderAtRoot/folder1/folder2/folder3                                                        | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3                                                        | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2/folder3                                                        | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | //vda1cs4850/folderAtRoot/folder1/folder2/folder3                                                        | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2/folder3                                                        | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3                                                        | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | //vda1cs4850/folderAtRoot/folder1/folder2/folder3                                                        | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3                                                        | true      |
| //vda1cs4850/users/somefile.d.ts                                                                         |                                                                                                          |           |
| //vda1cs4850/users/dir/somefile.d.ts                                                                     |                                                                                                          |           |
| //vda1cs4850/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/users/dir/subdir                                                                            | true      |
| //vda1cs4850/users/username/somefile.d.ts                                                                |                                                                                                          |           |
| //vda1cs4850/users/username/dir/somefile.d.ts                                                            | //vda1cs4850/users/username/dir                                                                          | true      |
| //vda1cs4850/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/users/username/dir                                                                          | true      |
| //vda1cs4850/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/dir/somefile.d.ts                                               | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/user/somefile.d.ts                                                                          |                                                                                                          |           |
| //vda1cs4850/user/dir/somefile.d.ts                                                                      |                                                                                                          |           |
| //vda1cs4850/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/user/dir/subdir                                                                             | true      |
| //vda1cs4850/user/username/somefile.d.ts                                                                 |                                                                                                          |           |
| //vda1cs4850/user/username/dir/somefile.d.ts                                                             | //vda1cs4850/user/username/dir                                                                           | true      |
| //vda1cs4850/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/user/username/dir                                                                           | true      |
| //vda1cs4850/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/usr/somefile.d.ts                                                                           |                                                                                                          |           |
| //vda1cs4850/usr/dir/somefile.d.ts                                                                       |                                                                                                          |           |
| //vda1cs4850/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/usr/dir/subdir                                                                              | true      |
| //vda1cs4850/usr/username/somefile.d.ts                                                                  |                                                                                                          |           |
| //vda1cs4850/usr/username/dir/somefile.d.ts                                                              | //vda1cs4850/usr/username/dir                                                                            | true      |
| //vda1cs4850/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/usr/username/dir                                                                            | true      |
| //vda1cs4850/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/home/somefile.d.ts                                                                          |                                                                                                          |           |
| //vda1cs4850/home/dir/somefile.d.ts                                                                      |                                                                                                          |           |
| //vda1cs4850/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/home/dir/subdir                                                                             | true      |
| //vda1cs4850/home/username/somefile.d.ts                                                                 |                                                                                                          |           |
| //vda1cs4850/home/username/dir/somefile.d.ts                                                             | //vda1cs4850/home/username/dir                                                                           | true      |
| //vda1cs4850/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/home/username/dir                                                                           | true      |
| //vda1cs4850/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |

## RootDirForResolution: //vda1cs4850/folderAtRoot/folder1/folder2/folder3

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/somefile.d.ts                                                                               |                                                                                                          |           |
| //vda1cs4850/dir/somefile.d.ts                                                                           |                                                                                                          |           |
| //vda1cs4850/dir/subdir/somefile.d.ts                                                                    |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/somefile.d.ts                                                                  |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/dir/somefile.d.ts                                                              |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/folderAtRoot/dir/subdir                                                                     | true      |
| //vda1cs4850/folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/folder1/dir/somefile.d.ts                                                      | //vda1cs4850/folderAtRoot/folder1/dir                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/folderAtRoot/folder1/dir                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | false     |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | //vda1cs4850/folderAtRoot/folder1/folder2/dir                                                            | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2/dir                                                            | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3                                                        | false     |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4                                                | true      |
| //vda1cs4850/users/somefile.d.ts                                                                         |                                                                                                          |           |
| //vda1cs4850/users/dir/somefile.d.ts                                                                     |                                                                                                          |           |
| //vda1cs4850/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/users/dir/subdir                                                                            | true      |
| //vda1cs4850/users/username/somefile.d.ts                                                                |                                                                                                          |           |
| //vda1cs4850/users/username/dir/somefile.d.ts                                                            | //vda1cs4850/users/username/dir                                                                          | true      |
| //vda1cs4850/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/users/username/dir                                                                          | true      |
| //vda1cs4850/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/dir/somefile.d.ts                                               | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/user/somefile.d.ts                                                                          |                                                                                                          |           |
| //vda1cs4850/user/dir/somefile.d.ts                                                                      |                                                                                                          |           |
| //vda1cs4850/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/user/dir/subdir                                                                             | true      |
| //vda1cs4850/user/username/somefile.d.ts                                                                 |                                                                                                          |           |
| //vda1cs4850/user/username/dir/somefile.d.ts                                                             | //vda1cs4850/user/username/dir                                                                           | true      |
| //vda1cs4850/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/user/username/dir                                                                           | true      |
| //vda1cs4850/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/usr/somefile.d.ts                                                                           |                                                                                                          |           |
| //vda1cs4850/usr/dir/somefile.d.ts                                                                       |                                                                                                          |           |
| //vda1cs4850/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/usr/dir/subdir                                                                              | true      |
| //vda1cs4850/usr/username/somefile.d.ts                                                                  |                                                                                                          |           |
| //vda1cs4850/usr/username/dir/somefile.d.ts                                                              | //vda1cs4850/usr/username/dir                                                                            | true      |
| //vda1cs4850/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/usr/username/dir                                                                            | true      |
| //vda1cs4850/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/home/somefile.d.ts                                                                          |                                                                                                          |           |
| //vda1cs4850/home/dir/somefile.d.ts                                                                      |                                                                                                          |           |
| //vda1cs4850/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/home/dir/subdir                                                                             | true      |
| //vda1cs4850/home/username/somefile.d.ts                                                                 |                                                                                                          |           |
| //vda1cs4850/home/username/dir/somefile.d.ts                                                             | //vda1cs4850/home/username/dir                                                                           | true      |
| //vda1cs4850/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/home/username/dir                                                                           | true      |
| //vda1cs4850/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |

## RootDirForResolution: //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/somefile.d.ts                                                                               |                                                                                                          |           |
| //vda1cs4850/dir/somefile.d.ts                                                                           |                                                                                                          |           |
| //vda1cs4850/dir/subdir/somefile.d.ts                                                                    |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/somefile.d.ts                                                                  |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/dir/somefile.d.ts                                                              |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/folderAtRoot/dir/subdir                                                                     | true      |
| //vda1cs4850/folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/folder1/dir/somefile.d.ts                                                      | //vda1cs4850/folderAtRoot/folder1/dir                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/folderAtRoot/folder1/dir                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | false     |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | //vda1cs4850/folderAtRoot/folder1/folder2/dir                                                            | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2/dir                                                            | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3                                                        | false     |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir                                            | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir                                            | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | true      |
| //vda1cs4850/users/somefile.d.ts                                                                         |                                                                                                          |           |
| //vda1cs4850/users/dir/somefile.d.ts                                                                     |                                                                                                          |           |
| //vda1cs4850/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/users/dir/subdir                                                                            | true      |
| //vda1cs4850/users/username/somefile.d.ts                                                                |                                                                                                          |           |
| //vda1cs4850/users/username/dir/somefile.d.ts                                                            | //vda1cs4850/users/username/dir                                                                          | true      |
| //vda1cs4850/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/users/username/dir                                                                          | true      |
| //vda1cs4850/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/dir/somefile.d.ts                                               | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/user/somefile.d.ts                                                                          |                                                                                                          |           |
| //vda1cs4850/user/dir/somefile.d.ts                                                                      |                                                                                                          |           |
| //vda1cs4850/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/user/dir/subdir                                                                             | true      |
| //vda1cs4850/user/username/somefile.d.ts                                                                 |                                                                                                          |           |
| //vda1cs4850/user/username/dir/somefile.d.ts                                                             | //vda1cs4850/user/username/dir                                                                           | true      |
| //vda1cs4850/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/user/username/dir                                                                           | true      |
| //vda1cs4850/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/usr/somefile.d.ts                                                                           |                                                                                                          |           |
| //vda1cs4850/usr/dir/somefile.d.ts                                                                       |                                                                                                          |           |
| //vda1cs4850/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/usr/dir/subdir                                                                              | true      |
| //vda1cs4850/usr/username/somefile.d.ts                                                                  |                                                                                                          |           |
| //vda1cs4850/usr/username/dir/somefile.d.ts                                                              | //vda1cs4850/usr/username/dir                                                                            | true      |
| //vda1cs4850/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/usr/username/dir                                                                            | true      |
| //vda1cs4850/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/home/somefile.d.ts                                                                          |                                                                                                          |           |
| //vda1cs4850/home/dir/somefile.d.ts                                                                      |                                                                                                          |           |
| //vda1cs4850/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/home/dir/subdir                                                                             | true      |
| //vda1cs4850/home/username/somefile.d.ts                                                                 |                                                                                                          |           |
| //vda1cs4850/home/username/dir/somefile.d.ts                                                             | //vda1cs4850/home/username/dir                                                                           | true      |
| //vda1cs4850/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/home/username/dir                                                                           | true      |
| //vda1cs4850/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |

## RootDirForResolution: //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/somefile.d.ts                                                                               |                                                                                                          |           |
| //vda1cs4850/dir/somefile.d.ts                                                                           |                                                                                                          |           |
| //vda1cs4850/dir/subdir/somefile.d.ts                                                                    |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/somefile.d.ts                                                                  |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/dir/somefile.d.ts                                                              |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/folderAtRoot/dir/subdir                                                                     | true      |
| //vda1cs4850/folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/folder1/dir/somefile.d.ts                                                      | //vda1cs4850/folderAtRoot/folder1/dir                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/folderAtRoot/folder1/dir                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | false     |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | //vda1cs4850/folderAtRoot/folder1/folder2/dir                                                            | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2/dir                                                            | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3                                                        | false     |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir                                            | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir                                            | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                                    | true      |
| //vda1cs4850/users/somefile.d.ts                                                                         |                                                                                                          |           |
| //vda1cs4850/users/dir/somefile.d.ts                                                                     |                                                                                                          |           |
| //vda1cs4850/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/users/dir/subdir                                                                            | true      |
| //vda1cs4850/users/username/somefile.d.ts                                                                |                                                                                                          |           |
| //vda1cs4850/users/username/dir/somefile.d.ts                                                            | //vda1cs4850/users/username/dir                                                                          | true      |
| //vda1cs4850/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/users/username/dir                                                                          | true      |
| //vda1cs4850/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/dir/somefile.d.ts                                               | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/user/somefile.d.ts                                                                          |                                                                                                          |           |
| //vda1cs4850/user/dir/somefile.d.ts                                                                      |                                                                                                          |           |
| //vda1cs4850/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/user/dir/subdir                                                                             | true      |
| //vda1cs4850/user/username/somefile.d.ts                                                                 |                                                                                                          |           |
| //vda1cs4850/user/username/dir/somefile.d.ts                                                             | //vda1cs4850/user/username/dir                                                                           | true      |
| //vda1cs4850/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/user/username/dir                                                                           | true      |
| //vda1cs4850/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/usr/somefile.d.ts                                                                           |                                                                                                          |           |
| //vda1cs4850/usr/dir/somefile.d.ts                                                                       |                                                                                                          |           |
| //vda1cs4850/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/usr/dir/subdir                                                                              | true      |
| //vda1cs4850/usr/username/somefile.d.ts                                                                  |                                                                                                          |           |
| //vda1cs4850/usr/username/dir/somefile.d.ts                                                              | //vda1cs4850/usr/username/dir                                                                            | true      |
| //vda1cs4850/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/usr/username/dir                                                                            | true      |
| //vda1cs4850/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/home/somefile.d.ts                                                                          |                                                                                                          |           |
| //vda1cs4850/home/dir/somefile.d.ts                                                                      |                                                                                                          |           |
| //vda1cs4850/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/home/dir/subdir                                                                             | true      |
| //vda1cs4850/home/username/somefile.d.ts                                                                 |                                                                                                          |           |
| //vda1cs4850/home/username/dir/somefile.d.ts                                                             | //vda1cs4850/home/username/dir                                                                           | true      |
| //vda1cs4850/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/home/username/dir                                                                           | true      |
| //vda1cs4850/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |

## RootDirForResolution: //vda1cs4850/users

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/somefile.d.ts                                                                               |                                                                                                          |           |
| //vda1cs4850/dir/somefile.d.ts                                                                           |                                                                                                          |           |
| //vda1cs4850/dir/subdir/somefile.d.ts                                                                    |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/somefile.d.ts                                                                  |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/dir/somefile.d.ts                                                              |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/folderAtRoot/dir/subdir                                                                     | true      |
| //vda1cs4850/folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/folder1/dir/somefile.d.ts                                                      | //vda1cs4850/folderAtRoot/folder1/dir                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/folderAtRoot/folder1/dir                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/users/somefile.d.ts                                                                         |                                                                                                          |           |
| //vda1cs4850/users/dir/somefile.d.ts                                                                     |                                                                                                          |           |
| //vda1cs4850/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/users/dir/subdir                                                                            | true      |
| //vda1cs4850/users/username/somefile.d.ts                                                                |                                                                                                          |           |
| //vda1cs4850/users/username/dir/somefile.d.ts                                                            | //vda1cs4850/users/username/dir                                                                          | true      |
| //vda1cs4850/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/users/username/dir                                                                          | true      |
| //vda1cs4850/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/dir/somefile.d.ts                                               | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/user/somefile.d.ts                                                                          |                                                                                                          |           |
| //vda1cs4850/user/dir/somefile.d.ts                                                                      |                                                                                                          |           |
| //vda1cs4850/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/user/dir/subdir                                                                             | true      |
| //vda1cs4850/user/username/somefile.d.ts                                                                 |                                                                                                          |           |
| //vda1cs4850/user/username/dir/somefile.d.ts                                                             | //vda1cs4850/user/username/dir                                                                           | true      |
| //vda1cs4850/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/user/username/dir                                                                           | true      |
| //vda1cs4850/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/usr/somefile.d.ts                                                                           |                                                                                                          |           |
| //vda1cs4850/usr/dir/somefile.d.ts                                                                       |                                                                                                          |           |
| //vda1cs4850/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/usr/dir/subdir                                                                              | true      |
| //vda1cs4850/usr/username/somefile.d.ts                                                                  |                                                                                                          |           |
| //vda1cs4850/usr/username/dir/somefile.d.ts                                                              | //vda1cs4850/usr/username/dir                                                                            | true      |
| //vda1cs4850/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/usr/username/dir                                                                            | true      |
| //vda1cs4850/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/home/somefile.d.ts                                                                          |                                                                                                          |           |
| //vda1cs4850/home/dir/somefile.d.ts                                                                      |                                                                                                          |           |
| //vda1cs4850/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/home/dir/subdir                                                                             | true      |
| //vda1cs4850/home/username/somefile.d.ts                                                                 |                                                                                                          |           |
| //vda1cs4850/home/username/dir/somefile.d.ts                                                             | //vda1cs4850/home/username/dir                                                                           | true      |
| //vda1cs4850/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/home/username/dir                                                                           | true      |
| //vda1cs4850/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |

## RootDirForResolution: //vda1cs4850/users/username

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/somefile.d.ts                                                                               |                                                                                                          |           |
| //vda1cs4850/dir/somefile.d.ts                                                                           |                                                                                                          |           |
| //vda1cs4850/dir/subdir/somefile.d.ts                                                                    |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/somefile.d.ts                                                                  |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/dir/somefile.d.ts                                                              |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/folderAtRoot/dir/subdir                                                                     | true      |
| //vda1cs4850/folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/folder1/dir/somefile.d.ts                                                      | //vda1cs4850/folderAtRoot/folder1/dir                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/folderAtRoot/folder1/dir                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/users/somefile.d.ts                                                                         |                                                                                                          |           |
| //vda1cs4850/users/dir/somefile.d.ts                                                                     |                                                                                                          |           |
| //vda1cs4850/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/users/dir/subdir                                                                            | true      |
| //vda1cs4850/users/username/somefile.d.ts                                                                |                                                                                                          |           |
| //vda1cs4850/users/username/dir/somefile.d.ts                                                            | //vda1cs4850/users/username/dir                                                                          | true      |
| //vda1cs4850/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/users/username/dir                                                                          | true      |
| //vda1cs4850/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/dir/somefile.d.ts                                               | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/user/somefile.d.ts                                                                          |                                                                                                          |           |
| //vda1cs4850/user/dir/somefile.d.ts                                                                      |                                                                                                          |           |
| //vda1cs4850/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/user/dir/subdir                                                                             | true      |
| //vda1cs4850/user/username/somefile.d.ts                                                                 |                                                                                                          |           |
| //vda1cs4850/user/username/dir/somefile.d.ts                                                             | //vda1cs4850/user/username/dir                                                                           | true      |
| //vda1cs4850/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/user/username/dir                                                                           | true      |
| //vda1cs4850/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/usr/somefile.d.ts                                                                           |                                                                                                          |           |
| //vda1cs4850/usr/dir/somefile.d.ts                                                                       |                                                                                                          |           |
| //vda1cs4850/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/usr/dir/subdir                                                                              | true      |
| //vda1cs4850/usr/username/somefile.d.ts                                                                  |                                                                                                          |           |
| //vda1cs4850/usr/username/dir/somefile.d.ts                                                              | //vda1cs4850/usr/username/dir                                                                            | true      |
| //vda1cs4850/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/usr/username/dir                                                                            | true      |
| //vda1cs4850/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/home/somefile.d.ts                                                                          |                                                                                                          |           |
| //vda1cs4850/home/dir/somefile.d.ts                                                                      |                                                                                                          |           |
| //vda1cs4850/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/home/dir/subdir                                                                             | true      |
| //vda1cs4850/home/username/somefile.d.ts                                                                 |                                                                                                          |           |
| //vda1cs4850/home/username/dir/somefile.d.ts                                                             | //vda1cs4850/home/username/dir                                                                           | true      |
| //vda1cs4850/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/home/username/dir                                                                           | true      |
| //vda1cs4850/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |

## RootDirForResolution: //vda1cs4850/users/username/folderAtRoot

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/somefile.d.ts                                                                               |                                                                                                          |           |
| //vda1cs4850/dir/somefile.d.ts                                                                           |                                                                                                          |           |
| //vda1cs4850/dir/subdir/somefile.d.ts                                                                    |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/somefile.d.ts                                                                  |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/dir/somefile.d.ts                                                              |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/folderAtRoot/dir/subdir                                                                     | true      |
| //vda1cs4850/folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/folder1/dir/somefile.d.ts                                                      | //vda1cs4850/folderAtRoot/folder1/dir                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/folderAtRoot/folder1/dir                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/users/somefile.d.ts                                                                         |                                                                                                          |           |
| //vda1cs4850/users/dir/somefile.d.ts                                                                     |                                                                                                          |           |
| //vda1cs4850/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/users/dir/subdir                                                                            | true      |
| //vda1cs4850/users/username/somefile.d.ts                                                                |                                                                                                          |           |
| //vda1cs4850/users/username/dir/somefile.d.ts                                                            | //vda1cs4850/users/username/dir                                                                          | true      |
| //vda1cs4850/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/users/username/dir                                                                          | true      |
| //vda1cs4850/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | false     |
| //vda1cs4850/users/username/folderAtRoot/dir/somefile.d.ts                                               | //vda1cs4850/users/username/folderAtRoot/dir                                                             | true      |
| //vda1cs4850/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot/dir                                                             | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot/folder1                                                         | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | //vda1cs4850/users/username/folderAtRoot/folder1                                                         | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot/folder1                                                         | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot/folder1                                                         | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | //vda1cs4850/users/username/folderAtRoot/folder1                                                         | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot/folder1                                                         | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot/folder1                                                         | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | //vda1cs4850/users/username/folderAtRoot/folder1                                                         | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot/folder1                                                         | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot/folder1                                                         | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | //vda1cs4850/users/username/folderAtRoot/folder1                                                         | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot/folder1                                                         | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot/folder1                                                         | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | //vda1cs4850/users/username/folderAtRoot/folder1                                                         | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot/folder1                                                         | true      |
| //vda1cs4850/user/somefile.d.ts                                                                          |                                                                                                          |           |
| //vda1cs4850/user/dir/somefile.d.ts                                                                      |                                                                                                          |           |
| //vda1cs4850/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/user/dir/subdir                                                                             | true      |
| //vda1cs4850/user/username/somefile.d.ts                                                                 |                                                                                                          |           |
| //vda1cs4850/user/username/dir/somefile.d.ts                                                             | //vda1cs4850/user/username/dir                                                                           | true      |
| //vda1cs4850/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/user/username/dir                                                                           | true      |
| //vda1cs4850/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/usr/somefile.d.ts                                                                           |                                                                                                          |           |
| //vda1cs4850/usr/dir/somefile.d.ts                                                                       |                                                                                                          |           |
| //vda1cs4850/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/usr/dir/subdir                                                                              | true      |
| //vda1cs4850/usr/username/somefile.d.ts                                                                  |                                                                                                          |           |
| //vda1cs4850/usr/username/dir/somefile.d.ts                                                              | //vda1cs4850/usr/username/dir                                                                            | true      |
| //vda1cs4850/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/usr/username/dir                                                                            | true      |
| //vda1cs4850/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/home/somefile.d.ts                                                                          |                                                                                                          |           |
| //vda1cs4850/home/dir/somefile.d.ts                                                                      |                                                                                                          |           |
| //vda1cs4850/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/home/dir/subdir                                                                             | true      |
| //vda1cs4850/home/username/somefile.d.ts                                                                 |                                                                                                          |           |
| //vda1cs4850/home/username/dir/somefile.d.ts                                                             | //vda1cs4850/home/username/dir                                                                           | true      |
| //vda1cs4850/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/home/username/dir                                                                           | true      |
| //vda1cs4850/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |

## RootDirForResolution: //vda1cs4850/users/username/folderAtRoot/folder1

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/somefile.d.ts                                                                               |                                                                                                          |           |
| //vda1cs4850/dir/somefile.d.ts                                                                           |                                                                                                          |           |
| //vda1cs4850/dir/subdir/somefile.d.ts                                                                    |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/somefile.d.ts                                                                  |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/dir/somefile.d.ts                                                              |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/folderAtRoot/dir/subdir                                                                     | true      |
| //vda1cs4850/folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/folder1/dir/somefile.d.ts                                                      | //vda1cs4850/folderAtRoot/folder1/dir                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/folderAtRoot/folder1/dir                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/users/somefile.d.ts                                                                         |                                                                                                          |           |
| //vda1cs4850/users/dir/somefile.d.ts                                                                     |                                                                                                          |           |
| //vda1cs4850/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/users/dir/subdir                                                                            | true      |
| //vda1cs4850/users/username/somefile.d.ts                                                                |                                                                                                          |           |
| //vda1cs4850/users/username/dir/somefile.d.ts                                                            | //vda1cs4850/users/username/dir                                                                          | true      |
| //vda1cs4850/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/users/username/dir                                                                          | true      |
| //vda1cs4850/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | false     |
| //vda1cs4850/users/username/folderAtRoot/dir/somefile.d.ts                                               | //vda1cs4850/users/username/folderAtRoot/dir                                                             | true      |
| //vda1cs4850/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot/dir                                                             | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot/folder1                                                         | false     |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | //vda1cs4850/users/username/folderAtRoot/folder1/dir                                                     | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot/folder1/dir                                                     | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | //vda1cs4850/users/username/folderAtRoot/folder1/folder2                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | //vda1cs4850/users/username/folderAtRoot/folder1/folder2                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot/folder1/folder2                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | //vda1cs4850/users/username/folderAtRoot/folder1/folder2                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | //vda1cs4850/users/username/folderAtRoot/folder1/folder2                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot/folder1/folder2                                                 | true      |
| //vda1cs4850/user/somefile.d.ts                                                                          |                                                                                                          |           |
| //vda1cs4850/user/dir/somefile.d.ts                                                                      |                                                                                                          |           |
| //vda1cs4850/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/user/dir/subdir                                                                             | true      |
| //vda1cs4850/user/username/somefile.d.ts                                                                 |                                                                                                          |           |
| //vda1cs4850/user/username/dir/somefile.d.ts                                                             | //vda1cs4850/user/username/dir                                                                           | true      |
| //vda1cs4850/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/user/username/dir                                                                           | true      |
| //vda1cs4850/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/usr/somefile.d.ts                                                                           |                                                                                                          |           |
| //vda1cs4850/usr/dir/somefile.d.ts                                                                       |                                                                                                          |           |
| //vda1cs4850/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/usr/dir/subdir                                                                              | true      |
| //vda1cs4850/usr/username/somefile.d.ts                                                                  |                                                                                                          |           |
| //vda1cs4850/usr/username/dir/somefile.d.ts                                                              | //vda1cs4850/usr/username/dir                                                                            | true      |
| //vda1cs4850/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/usr/username/dir                                                                            | true      |
| //vda1cs4850/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/home/somefile.d.ts                                                                          |                                                                                                          |           |
| //vda1cs4850/home/dir/somefile.d.ts                                                                      |                                                                                                          |           |
| //vda1cs4850/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/home/dir/subdir                                                                             | true      |
| //vda1cs4850/home/username/somefile.d.ts                                                                 |                                                                                                          |           |
| //vda1cs4850/home/username/dir/somefile.d.ts                                                             | //vda1cs4850/home/username/dir                                                                           | true      |
| //vda1cs4850/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/home/username/dir                                                                           | true      |
| //vda1cs4850/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |

## RootDirForResolution: //vda1cs4850/users/username/folderAtRoot/folder1/folder2

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/somefile.d.ts                                                                               |                                                                                                          |           |
| //vda1cs4850/dir/somefile.d.ts                                                                           |                                                                                                          |           |
| //vda1cs4850/dir/subdir/somefile.d.ts                                                                    |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/somefile.d.ts                                                                  |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/dir/somefile.d.ts                                                              |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/folderAtRoot/dir/subdir                                                                     | true      |
| //vda1cs4850/folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/folder1/dir/somefile.d.ts                                                      | //vda1cs4850/folderAtRoot/folder1/dir                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/folderAtRoot/folder1/dir                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/users/somefile.d.ts                                                                         |                                                                                                          |           |
| //vda1cs4850/users/dir/somefile.d.ts                                                                     |                                                                                                          |           |
| //vda1cs4850/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/users/dir/subdir                                                                            | true      |
| //vda1cs4850/users/username/somefile.d.ts                                                                |                                                                                                          |           |
| //vda1cs4850/users/username/dir/somefile.d.ts                                                            | //vda1cs4850/users/username/dir                                                                          | true      |
| //vda1cs4850/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/users/username/dir                                                                          | true      |
| //vda1cs4850/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | false     |
| //vda1cs4850/users/username/folderAtRoot/dir/somefile.d.ts                                               | //vda1cs4850/users/username/folderAtRoot/dir                                                             | true      |
| //vda1cs4850/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot/dir                                                             | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot/folder1                                                         | false     |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | //vda1cs4850/users/username/folderAtRoot/folder1/dir                                                     | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot/folder1/dir                                                     | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2                                                 | false     |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir                                             | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir                                             | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3                                         | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3                                         | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3                                         | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3                                         | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3                                         | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3                                         | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3                                         | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3                                         | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3                                         | true      |
| //vda1cs4850/user/somefile.d.ts                                                                          |                                                                                                          |           |
| //vda1cs4850/user/dir/somefile.d.ts                                                                      |                                                                                                          |           |
| //vda1cs4850/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/user/dir/subdir                                                                             | true      |
| //vda1cs4850/user/username/somefile.d.ts                                                                 |                                                                                                          |           |
| //vda1cs4850/user/username/dir/somefile.d.ts                                                             | //vda1cs4850/user/username/dir                                                                           | true      |
| //vda1cs4850/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/user/username/dir                                                                           | true      |
| //vda1cs4850/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/usr/somefile.d.ts                                                                           |                                                                                                          |           |
| //vda1cs4850/usr/dir/somefile.d.ts                                                                       |                                                                                                          |           |
| //vda1cs4850/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/usr/dir/subdir                                                                              | true      |
| //vda1cs4850/usr/username/somefile.d.ts                                                                  |                                                                                                          |           |
| //vda1cs4850/usr/username/dir/somefile.d.ts                                                              | //vda1cs4850/usr/username/dir                                                                            | true      |
| //vda1cs4850/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/usr/username/dir                                                                            | true      |
| //vda1cs4850/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/home/somefile.d.ts                                                                          |                                                                                                          |           |
| //vda1cs4850/home/dir/somefile.d.ts                                                                      |                                                                                                          |           |
| //vda1cs4850/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/home/dir/subdir                                                                             | true      |
| //vda1cs4850/home/username/somefile.d.ts                                                                 |                                                                                                          |           |
| //vda1cs4850/home/username/dir/somefile.d.ts                                                             | //vda1cs4850/home/username/dir                                                                           | true      |
| //vda1cs4850/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/home/username/dir                                                                           | true      |
| //vda1cs4850/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |

## RootDirForResolution: //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/somefile.d.ts                                                                               |                                                                                                          |           |
| //vda1cs4850/dir/somefile.d.ts                                                                           |                                                                                                          |           |
| //vda1cs4850/dir/subdir/somefile.d.ts                                                                    |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/somefile.d.ts                                                                  |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/dir/somefile.d.ts                                                              |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/folderAtRoot/dir/subdir                                                                     | true      |
| //vda1cs4850/folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/folder1/dir/somefile.d.ts                                                      | //vda1cs4850/folderAtRoot/folder1/dir                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/folderAtRoot/folder1/dir                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/users/somefile.d.ts                                                                         |                                                                                                          |           |
| //vda1cs4850/users/dir/somefile.d.ts                                                                     |                                                                                                          |           |
| //vda1cs4850/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/users/dir/subdir                                                                            | true      |
| //vda1cs4850/users/username/somefile.d.ts                                                                |                                                                                                          |           |
| //vda1cs4850/users/username/dir/somefile.d.ts                                                            | //vda1cs4850/users/username/dir                                                                          | true      |
| //vda1cs4850/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/users/username/dir                                                                          | true      |
| //vda1cs4850/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | false     |
| //vda1cs4850/users/username/folderAtRoot/dir/somefile.d.ts                                               | //vda1cs4850/users/username/folderAtRoot/dir                                                             | true      |
| //vda1cs4850/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot/dir                                                             | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot/folder1                                                         | false     |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | //vda1cs4850/users/username/folderAtRoot/folder1/dir                                                     | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot/folder1/dir                                                     | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2                                                 | false     |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir                                             | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir                                             | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir                                     | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir                                     | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | true      |
| //vda1cs4850/user/somefile.d.ts                                                                          |                                                                                                          |           |
| //vda1cs4850/user/dir/somefile.d.ts                                                                      |                                                                                                          |           |
| //vda1cs4850/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/user/dir/subdir                                                                             | true      |
| //vda1cs4850/user/username/somefile.d.ts                                                                 |                                                                                                          |           |
| //vda1cs4850/user/username/dir/somefile.d.ts                                                             | //vda1cs4850/user/username/dir                                                                           | true      |
| //vda1cs4850/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/user/username/dir                                                                           | true      |
| //vda1cs4850/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/usr/somefile.d.ts                                                                           |                                                                                                          |           |
| //vda1cs4850/usr/dir/somefile.d.ts                                                                       |                                                                                                          |           |
| //vda1cs4850/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/usr/dir/subdir                                                                              | true      |
| //vda1cs4850/usr/username/somefile.d.ts                                                                  |                                                                                                          |           |
| //vda1cs4850/usr/username/dir/somefile.d.ts                                                              | //vda1cs4850/usr/username/dir                                                                            | true      |
| //vda1cs4850/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/usr/username/dir                                                                            | true      |
| //vda1cs4850/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/home/somefile.d.ts                                                                          |                                                                                                          |           |
| //vda1cs4850/home/dir/somefile.d.ts                                                                      |                                                                                                          |           |
| //vda1cs4850/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/home/dir/subdir                                                                             | true      |
| //vda1cs4850/home/username/somefile.d.ts                                                                 |                                                                                                          |           |
| //vda1cs4850/home/username/dir/somefile.d.ts                                                             | //vda1cs4850/home/username/dir                                                                           | true      |
| //vda1cs4850/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/home/username/dir                                                                           | true      |
| //vda1cs4850/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |

## RootDirForResolution: //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/somefile.d.ts                                                                               |                                                                                                          |           |
| //vda1cs4850/dir/somefile.d.ts                                                                           |                                                                                                          |           |
| //vda1cs4850/dir/subdir/somefile.d.ts                                                                    |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/somefile.d.ts                                                                  |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/dir/somefile.d.ts                                                              |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/folderAtRoot/dir/subdir                                                                     | true      |
| //vda1cs4850/folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/folder1/dir/somefile.d.ts                                                      | //vda1cs4850/folderAtRoot/folder1/dir                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/folderAtRoot/folder1/dir                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/users/somefile.d.ts                                                                         |                                                                                                          |           |
| //vda1cs4850/users/dir/somefile.d.ts                                                                     |                                                                                                          |           |
| //vda1cs4850/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/users/dir/subdir                                                                            | true      |
| //vda1cs4850/users/username/somefile.d.ts                                                                |                                                                                                          |           |
| //vda1cs4850/users/username/dir/somefile.d.ts                                                            | //vda1cs4850/users/username/dir                                                                          | true      |
| //vda1cs4850/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/users/username/dir                                                                          | true      |
| //vda1cs4850/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | false     |
| //vda1cs4850/users/username/folderAtRoot/dir/somefile.d.ts                                               | //vda1cs4850/users/username/folderAtRoot/dir                                                             | true      |
| //vda1cs4850/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot/dir                                                             | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot/folder1                                                         | false     |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | //vda1cs4850/users/username/folderAtRoot/folder1/dir                                                     | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot/folder1/dir                                                     | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2                                                 | false     |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir                                             | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir                                             | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir                                     | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir                                     | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                             | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                             | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | true      |
| //vda1cs4850/user/somefile.d.ts                                                                          |                                                                                                          |           |
| //vda1cs4850/user/dir/somefile.d.ts                                                                      |                                                                                                          |           |
| //vda1cs4850/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/user/dir/subdir                                                                             | true      |
| //vda1cs4850/user/username/somefile.d.ts                                                                 |                                                                                                          |           |
| //vda1cs4850/user/username/dir/somefile.d.ts                                                             | //vda1cs4850/user/username/dir                                                                           | true      |
| //vda1cs4850/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/user/username/dir                                                                           | true      |
| //vda1cs4850/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/usr/somefile.d.ts                                                                           |                                                                                                          |           |
| //vda1cs4850/usr/dir/somefile.d.ts                                                                       |                                                                                                          |           |
| //vda1cs4850/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/usr/dir/subdir                                                                              | true      |
| //vda1cs4850/usr/username/somefile.d.ts                                                                  |                                                                                                          |           |
| //vda1cs4850/usr/username/dir/somefile.d.ts                                                              | //vda1cs4850/usr/username/dir                                                                            | true      |
| //vda1cs4850/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/usr/username/dir                                                                            | true      |
| //vda1cs4850/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/home/somefile.d.ts                                                                          |                                                                                                          |           |
| //vda1cs4850/home/dir/somefile.d.ts                                                                      |                                                                                                          |           |
| //vda1cs4850/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/home/dir/subdir                                                                             | true      |
| //vda1cs4850/home/username/somefile.d.ts                                                                 |                                                                                                          |           |
| //vda1cs4850/home/username/dir/somefile.d.ts                                                             | //vda1cs4850/home/username/dir                                                                           | true      |
| //vda1cs4850/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/home/username/dir                                                                           | true      |
| //vda1cs4850/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |

## RootDirForResolution: //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/somefile.d.ts                                                                               |                                                                                                          |           |
| //vda1cs4850/dir/somefile.d.ts                                                                           |                                                                                                          |           |
| //vda1cs4850/dir/subdir/somefile.d.ts                                                                    |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/somefile.d.ts                                                                  |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/dir/somefile.d.ts                                                              |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/folderAtRoot/dir/subdir                                                                     | true      |
| //vda1cs4850/folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/folder1/dir/somefile.d.ts                                                      | //vda1cs4850/folderAtRoot/folder1/dir                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/folderAtRoot/folder1/dir                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/users/somefile.d.ts                                                                         |                                                                                                          |           |
| //vda1cs4850/users/dir/somefile.d.ts                                                                     |                                                                                                          |           |
| //vda1cs4850/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/users/dir/subdir                                                                            | true      |
| //vda1cs4850/users/username/somefile.d.ts                                                                |                                                                                                          |           |
| //vda1cs4850/users/username/dir/somefile.d.ts                                                            | //vda1cs4850/users/username/dir                                                                          | true      |
| //vda1cs4850/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/users/username/dir                                                                          | true      |
| //vda1cs4850/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | false     |
| //vda1cs4850/users/username/folderAtRoot/dir/somefile.d.ts                                               | //vda1cs4850/users/username/folderAtRoot/dir                                                             | true      |
| //vda1cs4850/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot/dir                                                             | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot/folder1                                                         | false     |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | //vda1cs4850/users/username/folderAtRoot/folder1/dir                                                     | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot/folder1/dir                                                     | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2                                                 | false     |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir                                             | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir                                             | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir                                     | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir                                     | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                             | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                             | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                     | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                     | true      |
| //vda1cs4850/user/somefile.d.ts                                                                          |                                                                                                          |           |
| //vda1cs4850/user/dir/somefile.d.ts                                                                      |                                                                                                          |           |
| //vda1cs4850/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/user/dir/subdir                                                                             | true      |
| //vda1cs4850/user/username/somefile.d.ts                                                                 |                                                                                                          |           |
| //vda1cs4850/user/username/dir/somefile.d.ts                                                             | //vda1cs4850/user/username/dir                                                                           | true      |
| //vda1cs4850/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/user/username/dir                                                                           | true      |
| //vda1cs4850/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/usr/somefile.d.ts                                                                           |                                                                                                          |           |
| //vda1cs4850/usr/dir/somefile.d.ts                                                                       |                                                                                                          |           |
| //vda1cs4850/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/usr/dir/subdir                                                                              | true      |
| //vda1cs4850/usr/username/somefile.d.ts                                                                  |                                                                                                          |           |
| //vda1cs4850/usr/username/dir/somefile.d.ts                                                              | //vda1cs4850/usr/username/dir                                                                            | true      |
| //vda1cs4850/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/usr/username/dir                                                                            | true      |
| //vda1cs4850/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/home/somefile.d.ts                                                                          |                                                                                                          |           |
| //vda1cs4850/home/dir/somefile.d.ts                                                                      |                                                                                                          |           |
| //vda1cs4850/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/home/dir/subdir                                                                             | true      |
| //vda1cs4850/home/username/somefile.d.ts                                                                 |                                                                                                          |           |
| //vda1cs4850/home/username/dir/somefile.d.ts                                                             | //vda1cs4850/home/username/dir                                                                           | true      |
| //vda1cs4850/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/home/username/dir                                                                           | true      |
| //vda1cs4850/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |

## RootDirForResolution: //vda1cs4850/user

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/somefile.d.ts                                                                               |                                                                                                          |           |
| //vda1cs4850/dir/somefile.d.ts                                                                           |                                                                                                          |           |
| //vda1cs4850/dir/subdir/somefile.d.ts                                                                    |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/somefile.d.ts                                                                  |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/dir/somefile.d.ts                                                              |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/folderAtRoot/dir/subdir                                                                     | true      |
| //vda1cs4850/folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/folder1/dir/somefile.d.ts                                                      | //vda1cs4850/folderAtRoot/folder1/dir                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/folderAtRoot/folder1/dir                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/users/somefile.d.ts                                                                         |                                                                                                          |           |
| //vda1cs4850/users/dir/somefile.d.ts                                                                     |                                                                                                          |           |
| //vda1cs4850/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/users/dir/subdir                                                                            | true      |
| //vda1cs4850/users/username/somefile.d.ts                                                                |                                                                                                          |           |
| //vda1cs4850/users/username/dir/somefile.d.ts                                                            | //vda1cs4850/users/username/dir                                                                          | true      |
| //vda1cs4850/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/users/username/dir                                                                          | true      |
| //vda1cs4850/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/dir/somefile.d.ts                                               | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/user/somefile.d.ts                                                                          |                                                                                                          |           |
| //vda1cs4850/user/dir/somefile.d.ts                                                                      |                                                                                                          |           |
| //vda1cs4850/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/user/dir/subdir                                                                             | true      |
| //vda1cs4850/user/username/somefile.d.ts                                                                 |                                                                                                          |           |
| //vda1cs4850/user/username/dir/somefile.d.ts                                                             | //vda1cs4850/user/username/dir                                                                           | true      |
| //vda1cs4850/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/user/username/dir                                                                           | true      |
| //vda1cs4850/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/usr/somefile.d.ts                                                                           |                                                                                                          |           |
| //vda1cs4850/usr/dir/somefile.d.ts                                                                       |                                                                                                          |           |
| //vda1cs4850/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/usr/dir/subdir                                                                              | true      |
| //vda1cs4850/usr/username/somefile.d.ts                                                                  |                                                                                                          |           |
| //vda1cs4850/usr/username/dir/somefile.d.ts                                                              | //vda1cs4850/usr/username/dir                                                                            | true      |
| //vda1cs4850/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/usr/username/dir                                                                            | true      |
| //vda1cs4850/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/home/somefile.d.ts                                                                          |                                                                                                          |           |
| //vda1cs4850/home/dir/somefile.d.ts                                                                      |                                                                                                          |           |
| //vda1cs4850/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/home/dir/subdir                                                                             | true      |
| //vda1cs4850/home/username/somefile.d.ts                                                                 |                                                                                                          |           |
| //vda1cs4850/home/username/dir/somefile.d.ts                                                             | //vda1cs4850/home/username/dir                                                                           | true      |
| //vda1cs4850/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/home/username/dir                                                                           | true      |
| //vda1cs4850/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |

## RootDirForResolution: //vda1cs4850/user/username

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/somefile.d.ts                                                                               |                                                                                                          |           |
| //vda1cs4850/dir/somefile.d.ts                                                                           |                                                                                                          |           |
| //vda1cs4850/dir/subdir/somefile.d.ts                                                                    |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/somefile.d.ts                                                                  |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/dir/somefile.d.ts                                                              |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/folderAtRoot/dir/subdir                                                                     | true      |
| //vda1cs4850/folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/folder1/dir/somefile.d.ts                                                      | //vda1cs4850/folderAtRoot/folder1/dir                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/folderAtRoot/folder1/dir                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/users/somefile.d.ts                                                                         |                                                                                                          |           |
| //vda1cs4850/users/dir/somefile.d.ts                                                                     |                                                                                                          |           |
| //vda1cs4850/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/users/dir/subdir                                                                            | true      |
| //vda1cs4850/users/username/somefile.d.ts                                                                |                                                                                                          |           |
| //vda1cs4850/users/username/dir/somefile.d.ts                                                            | //vda1cs4850/users/username/dir                                                                          | true      |
| //vda1cs4850/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/users/username/dir                                                                          | true      |
| //vda1cs4850/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/dir/somefile.d.ts                                               | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/user/somefile.d.ts                                                                          |                                                                                                          |           |
| //vda1cs4850/user/dir/somefile.d.ts                                                                      |                                                                                                          |           |
| //vda1cs4850/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/user/dir/subdir                                                                             | true      |
| //vda1cs4850/user/username/somefile.d.ts                                                                 |                                                                                                          |           |
| //vda1cs4850/user/username/dir/somefile.d.ts                                                             | //vda1cs4850/user/username/dir                                                                           | true      |
| //vda1cs4850/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/user/username/dir                                                                           | true      |
| //vda1cs4850/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/usr/somefile.d.ts                                                                           |                                                                                                          |           |
| //vda1cs4850/usr/dir/somefile.d.ts                                                                       |                                                                                                          |           |
| //vda1cs4850/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/usr/dir/subdir                                                                              | true      |
| //vda1cs4850/usr/username/somefile.d.ts                                                                  |                                                                                                          |           |
| //vda1cs4850/usr/username/dir/somefile.d.ts                                                              | //vda1cs4850/usr/username/dir                                                                            | true      |
| //vda1cs4850/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/usr/username/dir                                                                            | true      |
| //vda1cs4850/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/home/somefile.d.ts                                                                          |                                                                                                          |           |
| //vda1cs4850/home/dir/somefile.d.ts                                                                      |                                                                                                          |           |
| //vda1cs4850/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/home/dir/subdir                                                                             | true      |
| //vda1cs4850/home/username/somefile.d.ts                                                                 |                                                                                                          |           |
| //vda1cs4850/home/username/dir/somefile.d.ts                                                             | //vda1cs4850/home/username/dir                                                                           | true      |
| //vda1cs4850/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/home/username/dir                                                                           | true      |
| //vda1cs4850/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |

## RootDirForResolution: //vda1cs4850/user/username/folderAtRoot

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/somefile.d.ts                                                                               |                                                                                                          |           |
| //vda1cs4850/dir/somefile.d.ts                                                                           |                                                                                                          |           |
| //vda1cs4850/dir/subdir/somefile.d.ts                                                                    |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/somefile.d.ts                                                                  |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/dir/somefile.d.ts                                                              |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/folderAtRoot/dir/subdir                                                                     | true      |
| //vda1cs4850/folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/folder1/dir/somefile.d.ts                                                      | //vda1cs4850/folderAtRoot/folder1/dir                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/folderAtRoot/folder1/dir                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/users/somefile.d.ts                                                                         |                                                                                                          |           |
| //vda1cs4850/users/dir/somefile.d.ts                                                                     |                                                                                                          |           |
| //vda1cs4850/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/users/dir/subdir                                                                            | true      |
| //vda1cs4850/users/username/somefile.d.ts                                                                |                                                                                                          |           |
| //vda1cs4850/users/username/dir/somefile.d.ts                                                            | //vda1cs4850/users/username/dir                                                                          | true      |
| //vda1cs4850/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/users/username/dir                                                                          | true      |
| //vda1cs4850/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/dir/somefile.d.ts                                               | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/user/somefile.d.ts                                                                          |                                                                                                          |           |
| //vda1cs4850/user/dir/somefile.d.ts                                                                      |                                                                                                          |           |
| //vda1cs4850/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/user/dir/subdir                                                                             | true      |
| //vda1cs4850/user/username/somefile.d.ts                                                                 |                                                                                                          |           |
| //vda1cs4850/user/username/dir/somefile.d.ts                                                             | //vda1cs4850/user/username/dir                                                                           | true      |
| //vda1cs4850/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/user/username/dir                                                                           | true      |
| //vda1cs4850/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | false     |
| //vda1cs4850/user/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/user/username/folderAtRoot/dir                                                              | true      |
| //vda1cs4850/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot/dir                                                              | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot/folder1                                                          | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/user/username/folderAtRoot/folder1                                                          | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot/folder1                                                          | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot/folder1                                                          | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/user/username/folderAtRoot/folder1                                                          | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot/folder1                                                          | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot/folder1                                                          | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/user/username/folderAtRoot/folder1                                                          | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot/folder1                                                          | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot/folder1                                                          | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/user/username/folderAtRoot/folder1                                                          | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot/folder1                                                          | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot/folder1                                                          | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/user/username/folderAtRoot/folder1                                                          | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot/folder1                                                          | true      |
| //vda1cs4850/usr/somefile.d.ts                                                                           |                                                                                                          |           |
| //vda1cs4850/usr/dir/somefile.d.ts                                                                       |                                                                                                          |           |
| //vda1cs4850/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/usr/dir/subdir                                                                              | true      |
| //vda1cs4850/usr/username/somefile.d.ts                                                                  |                                                                                                          |           |
| //vda1cs4850/usr/username/dir/somefile.d.ts                                                              | //vda1cs4850/usr/username/dir                                                                            | true      |
| //vda1cs4850/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/usr/username/dir                                                                            | true      |
| //vda1cs4850/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/home/somefile.d.ts                                                                          |                                                                                                          |           |
| //vda1cs4850/home/dir/somefile.d.ts                                                                      |                                                                                                          |           |
| //vda1cs4850/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/home/dir/subdir                                                                             | true      |
| //vda1cs4850/home/username/somefile.d.ts                                                                 |                                                                                                          |           |
| //vda1cs4850/home/username/dir/somefile.d.ts                                                             | //vda1cs4850/home/username/dir                                                                           | true      |
| //vda1cs4850/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/home/username/dir                                                                           | true      |
| //vda1cs4850/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |

## RootDirForResolution: //vda1cs4850/user/username/folderAtRoot/folder1

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/somefile.d.ts                                                                               |                                                                                                          |           |
| //vda1cs4850/dir/somefile.d.ts                                                                           |                                                                                                          |           |
| //vda1cs4850/dir/subdir/somefile.d.ts                                                                    |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/somefile.d.ts                                                                  |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/dir/somefile.d.ts                                                              |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/folderAtRoot/dir/subdir                                                                     | true      |
| //vda1cs4850/folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/folder1/dir/somefile.d.ts                                                      | //vda1cs4850/folderAtRoot/folder1/dir                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/folderAtRoot/folder1/dir                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/users/somefile.d.ts                                                                         |                                                                                                          |           |
| //vda1cs4850/users/dir/somefile.d.ts                                                                     |                                                                                                          |           |
| //vda1cs4850/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/users/dir/subdir                                                                            | true      |
| //vda1cs4850/users/username/somefile.d.ts                                                                |                                                                                                          |           |
| //vda1cs4850/users/username/dir/somefile.d.ts                                                            | //vda1cs4850/users/username/dir                                                                          | true      |
| //vda1cs4850/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/users/username/dir                                                                          | true      |
| //vda1cs4850/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/dir/somefile.d.ts                                               | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/user/somefile.d.ts                                                                          |                                                                                                          |           |
| //vda1cs4850/user/dir/somefile.d.ts                                                                      |                                                                                                          |           |
| //vda1cs4850/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/user/dir/subdir                                                                             | true      |
| //vda1cs4850/user/username/somefile.d.ts                                                                 |                                                                                                          |           |
| //vda1cs4850/user/username/dir/somefile.d.ts                                                             | //vda1cs4850/user/username/dir                                                                           | true      |
| //vda1cs4850/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/user/username/dir                                                                           | true      |
| //vda1cs4850/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | false     |
| //vda1cs4850/user/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/user/username/folderAtRoot/dir                                                              | true      |
| //vda1cs4850/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot/dir                                                              | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot/folder1                                                          | false     |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/user/username/folderAtRoot/folder1/dir                                                      | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot/folder1/dir                                                      | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/user/username/folderAtRoot/folder1/folder2                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/user/username/folderAtRoot/folder1/folder2                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot/folder1/folder2                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/user/username/folderAtRoot/folder1/folder2                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/user/username/folderAtRoot/folder1/folder2                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot/folder1/folder2                                                  | true      |
| //vda1cs4850/usr/somefile.d.ts                                                                           |                                                                                                          |           |
| //vda1cs4850/usr/dir/somefile.d.ts                                                                       |                                                                                                          |           |
| //vda1cs4850/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/usr/dir/subdir                                                                              | true      |
| //vda1cs4850/usr/username/somefile.d.ts                                                                  |                                                                                                          |           |
| //vda1cs4850/usr/username/dir/somefile.d.ts                                                              | //vda1cs4850/usr/username/dir                                                                            | true      |
| //vda1cs4850/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/usr/username/dir                                                                            | true      |
| //vda1cs4850/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/home/somefile.d.ts                                                                          |                                                                                                          |           |
| //vda1cs4850/home/dir/somefile.d.ts                                                                      |                                                                                                          |           |
| //vda1cs4850/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/home/dir/subdir                                                                             | true      |
| //vda1cs4850/home/username/somefile.d.ts                                                                 |                                                                                                          |           |
| //vda1cs4850/home/username/dir/somefile.d.ts                                                             | //vda1cs4850/home/username/dir                                                                           | true      |
| //vda1cs4850/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/home/username/dir                                                                           | true      |
| //vda1cs4850/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |

## RootDirForResolution: //vda1cs4850/user/username/folderAtRoot/folder1/folder2

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/somefile.d.ts                                                                               |                                                                                                          |           |
| //vda1cs4850/dir/somefile.d.ts                                                                           |                                                                                                          |           |
| //vda1cs4850/dir/subdir/somefile.d.ts                                                                    |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/somefile.d.ts                                                                  |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/dir/somefile.d.ts                                                              |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/folderAtRoot/dir/subdir                                                                     | true      |
| //vda1cs4850/folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/folder1/dir/somefile.d.ts                                                      | //vda1cs4850/folderAtRoot/folder1/dir                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/folderAtRoot/folder1/dir                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/users/somefile.d.ts                                                                         |                                                                                                          |           |
| //vda1cs4850/users/dir/somefile.d.ts                                                                     |                                                                                                          |           |
| //vda1cs4850/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/users/dir/subdir                                                                            | true      |
| //vda1cs4850/users/username/somefile.d.ts                                                                |                                                                                                          |           |
| //vda1cs4850/users/username/dir/somefile.d.ts                                                            | //vda1cs4850/users/username/dir                                                                          | true      |
| //vda1cs4850/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/users/username/dir                                                                          | true      |
| //vda1cs4850/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/dir/somefile.d.ts                                               | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/user/somefile.d.ts                                                                          |                                                                                                          |           |
| //vda1cs4850/user/dir/somefile.d.ts                                                                      |                                                                                                          |           |
| //vda1cs4850/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/user/dir/subdir                                                                             | true      |
| //vda1cs4850/user/username/somefile.d.ts                                                                 |                                                                                                          |           |
| //vda1cs4850/user/username/dir/somefile.d.ts                                                             | //vda1cs4850/user/username/dir                                                                           | true      |
| //vda1cs4850/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/user/username/dir                                                                           | true      |
| //vda1cs4850/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | false     |
| //vda1cs4850/user/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/user/username/folderAtRoot/dir                                                              | true      |
| //vda1cs4850/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot/dir                                                              | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot/folder1                                                          | false     |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/user/username/folderAtRoot/folder1/dir                                                      | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot/folder1/dir                                                      | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2                                                  | false     |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir                                              | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir                                              | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3                                          | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3                                          | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3                                          | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3                                          | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3                                          | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3                                          | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3                                          | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3                                          | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3                                          | true      |
| //vda1cs4850/usr/somefile.d.ts                                                                           |                                                                                                          |           |
| //vda1cs4850/usr/dir/somefile.d.ts                                                                       |                                                                                                          |           |
| //vda1cs4850/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/usr/dir/subdir                                                                              | true      |
| //vda1cs4850/usr/username/somefile.d.ts                                                                  |                                                                                                          |           |
| //vda1cs4850/usr/username/dir/somefile.d.ts                                                              | //vda1cs4850/usr/username/dir                                                                            | true      |
| //vda1cs4850/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/usr/username/dir                                                                            | true      |
| //vda1cs4850/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/home/somefile.d.ts                                                                          |                                                                                                          |           |
| //vda1cs4850/home/dir/somefile.d.ts                                                                      |                                                                                                          |           |
| //vda1cs4850/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/home/dir/subdir                                                                             | true      |
| //vda1cs4850/home/username/somefile.d.ts                                                                 |                                                                                                          |           |
| //vda1cs4850/home/username/dir/somefile.d.ts                                                             | //vda1cs4850/home/username/dir                                                                           | true      |
| //vda1cs4850/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/home/username/dir                                                                           | true      |
| //vda1cs4850/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |

## RootDirForResolution: //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/somefile.d.ts                                                                               |                                                                                                          |           |
| //vda1cs4850/dir/somefile.d.ts                                                                           |                                                                                                          |           |
| //vda1cs4850/dir/subdir/somefile.d.ts                                                                    |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/somefile.d.ts                                                                  |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/dir/somefile.d.ts                                                              |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/folderAtRoot/dir/subdir                                                                     | true      |
| //vda1cs4850/folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/folder1/dir/somefile.d.ts                                                      | //vda1cs4850/folderAtRoot/folder1/dir                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/folderAtRoot/folder1/dir                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/users/somefile.d.ts                                                                         |                                                                                                          |           |
| //vda1cs4850/users/dir/somefile.d.ts                                                                     |                                                                                                          |           |
| //vda1cs4850/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/users/dir/subdir                                                                            | true      |
| //vda1cs4850/users/username/somefile.d.ts                                                                |                                                                                                          |           |
| //vda1cs4850/users/username/dir/somefile.d.ts                                                            | //vda1cs4850/users/username/dir                                                                          | true      |
| //vda1cs4850/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/users/username/dir                                                                          | true      |
| //vda1cs4850/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/dir/somefile.d.ts                                               | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/user/somefile.d.ts                                                                          |                                                                                                          |           |
| //vda1cs4850/user/dir/somefile.d.ts                                                                      |                                                                                                          |           |
| //vda1cs4850/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/user/dir/subdir                                                                             | true      |
| //vda1cs4850/user/username/somefile.d.ts                                                                 |                                                                                                          |           |
| //vda1cs4850/user/username/dir/somefile.d.ts                                                             | //vda1cs4850/user/username/dir                                                                           | true      |
| //vda1cs4850/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/user/username/dir                                                                           | true      |
| //vda1cs4850/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | false     |
| //vda1cs4850/user/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/user/username/folderAtRoot/dir                                                              | true      |
| //vda1cs4850/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot/dir                                                              | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot/folder1                                                          | false     |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/user/username/folderAtRoot/folder1/dir                                                      | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot/folder1/dir                                                      | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2                                                  | false     |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir                                              | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir                                              | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir                                      | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir                                      | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | true      |
| //vda1cs4850/usr/somefile.d.ts                                                                           |                                                                                                          |           |
| //vda1cs4850/usr/dir/somefile.d.ts                                                                       |                                                                                                          |           |
| //vda1cs4850/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/usr/dir/subdir                                                                              | true      |
| //vda1cs4850/usr/username/somefile.d.ts                                                                  |                                                                                                          |           |
| //vda1cs4850/usr/username/dir/somefile.d.ts                                                              | //vda1cs4850/usr/username/dir                                                                            | true      |
| //vda1cs4850/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/usr/username/dir                                                                            | true      |
| //vda1cs4850/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/home/somefile.d.ts                                                                          |                                                                                                          |           |
| //vda1cs4850/home/dir/somefile.d.ts                                                                      |                                                                                                          |           |
| //vda1cs4850/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/home/dir/subdir                                                                             | true      |
| //vda1cs4850/home/username/somefile.d.ts                                                                 |                                                                                                          |           |
| //vda1cs4850/home/username/dir/somefile.d.ts                                                             | //vda1cs4850/home/username/dir                                                                           | true      |
| //vda1cs4850/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/home/username/dir                                                                           | true      |
| //vda1cs4850/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |

## RootDirForResolution: //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/somefile.d.ts                                                                               |                                                                                                          |           |
| //vda1cs4850/dir/somefile.d.ts                                                                           |                                                                                                          |           |
| //vda1cs4850/dir/subdir/somefile.d.ts                                                                    |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/somefile.d.ts                                                                  |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/dir/somefile.d.ts                                                              |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/folderAtRoot/dir/subdir                                                                     | true      |
| //vda1cs4850/folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/folder1/dir/somefile.d.ts                                                      | //vda1cs4850/folderAtRoot/folder1/dir                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/folderAtRoot/folder1/dir                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/users/somefile.d.ts                                                                         |                                                                                                          |           |
| //vda1cs4850/users/dir/somefile.d.ts                                                                     |                                                                                                          |           |
| //vda1cs4850/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/users/dir/subdir                                                                            | true      |
| //vda1cs4850/users/username/somefile.d.ts                                                                |                                                                                                          |           |
| //vda1cs4850/users/username/dir/somefile.d.ts                                                            | //vda1cs4850/users/username/dir                                                                          | true      |
| //vda1cs4850/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/users/username/dir                                                                          | true      |
| //vda1cs4850/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/dir/somefile.d.ts                                               | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/user/somefile.d.ts                                                                          |                                                                                                          |           |
| //vda1cs4850/user/dir/somefile.d.ts                                                                      |                                                                                                          |           |
| //vda1cs4850/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/user/dir/subdir                                                                             | true      |
| //vda1cs4850/user/username/somefile.d.ts                                                                 |                                                                                                          |           |
| //vda1cs4850/user/username/dir/somefile.d.ts                                                             | //vda1cs4850/user/username/dir                                                                           | true      |
| //vda1cs4850/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/user/username/dir                                                                           | true      |
| //vda1cs4850/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | false     |
| //vda1cs4850/user/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/user/username/folderAtRoot/dir                                                              | true      |
| //vda1cs4850/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot/dir                                                              | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot/folder1                                                          | false     |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/user/username/folderAtRoot/folder1/dir                                                      | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot/folder1/dir                                                      | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2                                                  | false     |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir                                              | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir                                              | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir                                      | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir                                      | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | true      |
| //vda1cs4850/usr/somefile.d.ts                                                                           |                                                                                                          |           |
| //vda1cs4850/usr/dir/somefile.d.ts                                                                       |                                                                                                          |           |
| //vda1cs4850/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/usr/dir/subdir                                                                              | true      |
| //vda1cs4850/usr/username/somefile.d.ts                                                                  |                                                                                                          |           |
| //vda1cs4850/usr/username/dir/somefile.d.ts                                                              | //vda1cs4850/usr/username/dir                                                                            | true      |
| //vda1cs4850/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/usr/username/dir                                                                            | true      |
| //vda1cs4850/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/home/somefile.d.ts                                                                          |                                                                                                          |           |
| //vda1cs4850/home/dir/somefile.d.ts                                                                      |                                                                                                          |           |
| //vda1cs4850/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/home/dir/subdir                                                                             | true      |
| //vda1cs4850/home/username/somefile.d.ts                                                                 |                                                                                                          |           |
| //vda1cs4850/home/username/dir/somefile.d.ts                                                             | //vda1cs4850/home/username/dir                                                                           | true      |
| //vda1cs4850/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/home/username/dir                                                                           | true      |
| //vda1cs4850/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |

## RootDirForResolution: //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/somefile.d.ts                                                                               |                                                                                                          |           |
| //vda1cs4850/dir/somefile.d.ts                                                                           |                                                                                                          |           |
| //vda1cs4850/dir/subdir/somefile.d.ts                                                                    |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/somefile.d.ts                                                                  |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/dir/somefile.d.ts                                                              |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/folderAtRoot/dir/subdir                                                                     | true      |
| //vda1cs4850/folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/folder1/dir/somefile.d.ts                                                      | //vda1cs4850/folderAtRoot/folder1/dir                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/folderAtRoot/folder1/dir                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/users/somefile.d.ts                                                                         |                                                                                                          |           |
| //vda1cs4850/users/dir/somefile.d.ts                                                                     |                                                                                                          |           |
| //vda1cs4850/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/users/dir/subdir                                                                            | true      |
| //vda1cs4850/users/username/somefile.d.ts                                                                |                                                                                                          |           |
| //vda1cs4850/users/username/dir/somefile.d.ts                                                            | //vda1cs4850/users/username/dir                                                                          | true      |
| //vda1cs4850/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/users/username/dir                                                                          | true      |
| //vda1cs4850/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/dir/somefile.d.ts                                               | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/user/somefile.d.ts                                                                          |                                                                                                          |           |
| //vda1cs4850/user/dir/somefile.d.ts                                                                      |                                                                                                          |           |
| //vda1cs4850/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/user/dir/subdir                                                                             | true      |
| //vda1cs4850/user/username/somefile.d.ts                                                                 |                                                                                                          |           |
| //vda1cs4850/user/username/dir/somefile.d.ts                                                             | //vda1cs4850/user/username/dir                                                                           | true      |
| //vda1cs4850/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/user/username/dir                                                                           | true      |
| //vda1cs4850/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | false     |
| //vda1cs4850/user/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/user/username/folderAtRoot/dir                                                              | true      |
| //vda1cs4850/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot/dir                                                              | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot/folder1                                                          | false     |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/user/username/folderAtRoot/folder1/dir                                                      | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot/folder1/dir                                                      | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2                                                  | false     |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir                                              | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir                                              | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir                                      | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir                                      | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | true      |
| //vda1cs4850/usr/somefile.d.ts                                                                           |                                                                                                          |           |
| //vda1cs4850/usr/dir/somefile.d.ts                                                                       |                                                                                                          |           |
| //vda1cs4850/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/usr/dir/subdir                                                                              | true      |
| //vda1cs4850/usr/username/somefile.d.ts                                                                  |                                                                                                          |           |
| //vda1cs4850/usr/username/dir/somefile.d.ts                                                              | //vda1cs4850/usr/username/dir                                                                            | true      |
| //vda1cs4850/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/usr/username/dir                                                                            | true      |
| //vda1cs4850/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/home/somefile.d.ts                                                                          |                                                                                                          |           |
| //vda1cs4850/home/dir/somefile.d.ts                                                                      |                                                                                                          |           |
| //vda1cs4850/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/home/dir/subdir                                                                             | true      |
| //vda1cs4850/home/username/somefile.d.ts                                                                 |                                                                                                          |           |
| //vda1cs4850/home/username/dir/somefile.d.ts                                                             | //vda1cs4850/home/username/dir                                                                           | true      |
| //vda1cs4850/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/home/username/dir                                                                           | true      |
| //vda1cs4850/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |

## RootDirForResolution: //vda1cs4850/usr

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/somefile.d.ts                                                                               |                                                                                                          |           |
| //vda1cs4850/dir/somefile.d.ts                                                                           |                                                                                                          |           |
| //vda1cs4850/dir/subdir/somefile.d.ts                                                                    |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/somefile.d.ts                                                                  |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/dir/somefile.d.ts                                                              |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/folderAtRoot/dir/subdir                                                                     | true      |
| //vda1cs4850/folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/folder1/dir/somefile.d.ts                                                      | //vda1cs4850/folderAtRoot/folder1/dir                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/folderAtRoot/folder1/dir                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/users/somefile.d.ts                                                                         |                                                                                                          |           |
| //vda1cs4850/users/dir/somefile.d.ts                                                                     |                                                                                                          |           |
| //vda1cs4850/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/users/dir/subdir                                                                            | true      |
| //vda1cs4850/users/username/somefile.d.ts                                                                |                                                                                                          |           |
| //vda1cs4850/users/username/dir/somefile.d.ts                                                            | //vda1cs4850/users/username/dir                                                                          | true      |
| //vda1cs4850/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/users/username/dir                                                                          | true      |
| //vda1cs4850/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/dir/somefile.d.ts                                               | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/user/somefile.d.ts                                                                          |                                                                                                          |           |
| //vda1cs4850/user/dir/somefile.d.ts                                                                      |                                                                                                          |           |
| //vda1cs4850/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/user/dir/subdir                                                                             | true      |
| //vda1cs4850/user/username/somefile.d.ts                                                                 |                                                                                                          |           |
| //vda1cs4850/user/username/dir/somefile.d.ts                                                             | //vda1cs4850/user/username/dir                                                                           | true      |
| //vda1cs4850/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/user/username/dir                                                                           | true      |
| //vda1cs4850/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/usr/somefile.d.ts                                                                           |                                                                                                          |           |
| //vda1cs4850/usr/dir/somefile.d.ts                                                                       |                                                                                                          |           |
| //vda1cs4850/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/usr/dir/subdir                                                                              | true      |
| //vda1cs4850/usr/username/somefile.d.ts                                                                  |                                                                                                          |           |
| //vda1cs4850/usr/username/dir/somefile.d.ts                                                              | //vda1cs4850/usr/username/dir                                                                            | true      |
| //vda1cs4850/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/usr/username/dir                                                                            | true      |
| //vda1cs4850/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/home/somefile.d.ts                                                                          |                                                                                                          |           |
| //vda1cs4850/home/dir/somefile.d.ts                                                                      |                                                                                                          |           |
| //vda1cs4850/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/home/dir/subdir                                                                             | true      |
| //vda1cs4850/home/username/somefile.d.ts                                                                 |                                                                                                          |           |
| //vda1cs4850/home/username/dir/somefile.d.ts                                                             | //vda1cs4850/home/username/dir                                                                           | true      |
| //vda1cs4850/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/home/username/dir                                                                           | true      |
| //vda1cs4850/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |

## RootDirForResolution: //vda1cs4850/usr/username

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/somefile.d.ts                                                                               |                                                                                                          |           |
| //vda1cs4850/dir/somefile.d.ts                                                                           |                                                                                                          |           |
| //vda1cs4850/dir/subdir/somefile.d.ts                                                                    |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/somefile.d.ts                                                                  |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/dir/somefile.d.ts                                                              |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/folderAtRoot/dir/subdir                                                                     | true      |
| //vda1cs4850/folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/folder1/dir/somefile.d.ts                                                      | //vda1cs4850/folderAtRoot/folder1/dir                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/folderAtRoot/folder1/dir                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/users/somefile.d.ts                                                                         |                                                                                                          |           |
| //vda1cs4850/users/dir/somefile.d.ts                                                                     |                                                                                                          |           |
| //vda1cs4850/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/users/dir/subdir                                                                            | true      |
| //vda1cs4850/users/username/somefile.d.ts                                                                |                                                                                                          |           |
| //vda1cs4850/users/username/dir/somefile.d.ts                                                            | //vda1cs4850/users/username/dir                                                                          | true      |
| //vda1cs4850/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/users/username/dir                                                                          | true      |
| //vda1cs4850/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/dir/somefile.d.ts                                               | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/user/somefile.d.ts                                                                          |                                                                                                          |           |
| //vda1cs4850/user/dir/somefile.d.ts                                                                      |                                                                                                          |           |
| //vda1cs4850/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/user/dir/subdir                                                                             | true      |
| //vda1cs4850/user/username/somefile.d.ts                                                                 |                                                                                                          |           |
| //vda1cs4850/user/username/dir/somefile.d.ts                                                             | //vda1cs4850/user/username/dir                                                                           | true      |
| //vda1cs4850/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/user/username/dir                                                                           | true      |
| //vda1cs4850/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/usr/somefile.d.ts                                                                           |                                                                                                          |           |
| //vda1cs4850/usr/dir/somefile.d.ts                                                                       |                                                                                                          |           |
| //vda1cs4850/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/usr/dir/subdir                                                                              | true      |
| //vda1cs4850/usr/username/somefile.d.ts                                                                  |                                                                                                          |           |
| //vda1cs4850/usr/username/dir/somefile.d.ts                                                              | //vda1cs4850/usr/username/dir                                                                            | true      |
| //vda1cs4850/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/usr/username/dir                                                                            | true      |
| //vda1cs4850/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/home/somefile.d.ts                                                                          |                                                                                                          |           |
| //vda1cs4850/home/dir/somefile.d.ts                                                                      |                                                                                                          |           |
| //vda1cs4850/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/home/dir/subdir                                                                             | true      |
| //vda1cs4850/home/username/somefile.d.ts                                                                 |                                                                                                          |           |
| //vda1cs4850/home/username/dir/somefile.d.ts                                                             | //vda1cs4850/home/username/dir                                                                           | true      |
| //vda1cs4850/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/home/username/dir                                                                           | true      |
| //vda1cs4850/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |

## RootDirForResolution: //vda1cs4850/usr/username/folderAtRoot

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/somefile.d.ts                                                                               |                                                                                                          |           |
| //vda1cs4850/dir/somefile.d.ts                                                                           |                                                                                                          |           |
| //vda1cs4850/dir/subdir/somefile.d.ts                                                                    |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/somefile.d.ts                                                                  |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/dir/somefile.d.ts                                                              |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/folderAtRoot/dir/subdir                                                                     | true      |
| //vda1cs4850/folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/folder1/dir/somefile.d.ts                                                      | //vda1cs4850/folderAtRoot/folder1/dir                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/folderAtRoot/folder1/dir                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/users/somefile.d.ts                                                                         |                                                                                                          |           |
| //vda1cs4850/users/dir/somefile.d.ts                                                                     |                                                                                                          |           |
| //vda1cs4850/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/users/dir/subdir                                                                            | true      |
| //vda1cs4850/users/username/somefile.d.ts                                                                |                                                                                                          |           |
| //vda1cs4850/users/username/dir/somefile.d.ts                                                            | //vda1cs4850/users/username/dir                                                                          | true      |
| //vda1cs4850/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/users/username/dir                                                                          | true      |
| //vda1cs4850/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/dir/somefile.d.ts                                               | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/user/somefile.d.ts                                                                          |                                                                                                          |           |
| //vda1cs4850/user/dir/somefile.d.ts                                                                      |                                                                                                          |           |
| //vda1cs4850/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/user/dir/subdir                                                                             | true      |
| //vda1cs4850/user/username/somefile.d.ts                                                                 |                                                                                                          |           |
| //vda1cs4850/user/username/dir/somefile.d.ts                                                             | //vda1cs4850/user/username/dir                                                                           | true      |
| //vda1cs4850/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/user/username/dir                                                                           | true      |
| //vda1cs4850/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/usr/somefile.d.ts                                                                           |                                                                                                          |           |
| //vda1cs4850/usr/dir/somefile.d.ts                                                                       |                                                                                                          |           |
| //vda1cs4850/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/usr/dir/subdir                                                                              | true      |
| //vda1cs4850/usr/username/somefile.d.ts                                                                  |                                                                                                          |           |
| //vda1cs4850/usr/username/dir/somefile.d.ts                                                              | //vda1cs4850/usr/username/dir                                                                            | true      |
| //vda1cs4850/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/usr/username/dir                                                                            | true      |
| //vda1cs4850/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | false     |
| //vda1cs4850/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | //vda1cs4850/usr/username/folderAtRoot/dir                                                               | true      |
| //vda1cs4850/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot/dir                                                               | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot/folder1                                                           | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | //vda1cs4850/usr/username/folderAtRoot/folder1                                                           | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot/folder1                                                           | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot/folder1                                                           | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | //vda1cs4850/usr/username/folderAtRoot/folder1                                                           | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot/folder1                                                           | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot/folder1                                                           | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | //vda1cs4850/usr/username/folderAtRoot/folder1                                                           | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot/folder1                                                           | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot/folder1                                                           | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | //vda1cs4850/usr/username/folderAtRoot/folder1                                                           | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot/folder1                                                           | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot/folder1                                                           | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | //vda1cs4850/usr/username/folderAtRoot/folder1                                                           | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot/folder1                                                           | true      |
| //vda1cs4850/home/somefile.d.ts                                                                          |                                                                                                          |           |
| //vda1cs4850/home/dir/somefile.d.ts                                                                      |                                                                                                          |           |
| //vda1cs4850/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/home/dir/subdir                                                                             | true      |
| //vda1cs4850/home/username/somefile.d.ts                                                                 |                                                                                                          |           |
| //vda1cs4850/home/username/dir/somefile.d.ts                                                             | //vda1cs4850/home/username/dir                                                                           | true      |
| //vda1cs4850/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/home/username/dir                                                                           | true      |
| //vda1cs4850/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |

## RootDirForResolution: //vda1cs4850/usr/username/folderAtRoot/folder1

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/somefile.d.ts                                                                               |                                                                                                          |           |
| //vda1cs4850/dir/somefile.d.ts                                                                           |                                                                                                          |           |
| //vda1cs4850/dir/subdir/somefile.d.ts                                                                    |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/somefile.d.ts                                                                  |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/dir/somefile.d.ts                                                              |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/folderAtRoot/dir/subdir                                                                     | true      |
| //vda1cs4850/folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/folder1/dir/somefile.d.ts                                                      | //vda1cs4850/folderAtRoot/folder1/dir                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/folderAtRoot/folder1/dir                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/users/somefile.d.ts                                                                         |                                                                                                          |           |
| //vda1cs4850/users/dir/somefile.d.ts                                                                     |                                                                                                          |           |
| //vda1cs4850/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/users/dir/subdir                                                                            | true      |
| //vda1cs4850/users/username/somefile.d.ts                                                                |                                                                                                          |           |
| //vda1cs4850/users/username/dir/somefile.d.ts                                                            | //vda1cs4850/users/username/dir                                                                          | true      |
| //vda1cs4850/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/users/username/dir                                                                          | true      |
| //vda1cs4850/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/dir/somefile.d.ts                                               | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/user/somefile.d.ts                                                                          |                                                                                                          |           |
| //vda1cs4850/user/dir/somefile.d.ts                                                                      |                                                                                                          |           |
| //vda1cs4850/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/user/dir/subdir                                                                             | true      |
| //vda1cs4850/user/username/somefile.d.ts                                                                 |                                                                                                          |           |
| //vda1cs4850/user/username/dir/somefile.d.ts                                                             | //vda1cs4850/user/username/dir                                                                           | true      |
| //vda1cs4850/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/user/username/dir                                                                           | true      |
| //vda1cs4850/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/usr/somefile.d.ts                                                                           |                                                                                                          |           |
| //vda1cs4850/usr/dir/somefile.d.ts                                                                       |                                                                                                          |           |
| //vda1cs4850/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/usr/dir/subdir                                                                              | true      |
| //vda1cs4850/usr/username/somefile.d.ts                                                                  |                                                                                                          |           |
| //vda1cs4850/usr/username/dir/somefile.d.ts                                                              | //vda1cs4850/usr/username/dir                                                                            | true      |
| //vda1cs4850/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/usr/username/dir                                                                            | true      |
| //vda1cs4850/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | false     |
| //vda1cs4850/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | //vda1cs4850/usr/username/folderAtRoot/dir                                                               | true      |
| //vda1cs4850/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot/dir                                                               | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot/folder1                                                           | false     |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | //vda1cs4850/usr/username/folderAtRoot/folder1/dir                                                       | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot/folder1/dir                                                       | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2                                                   | true      |
| //vda1cs4850/home/somefile.d.ts                                                                          |                                                                                                          |           |
| //vda1cs4850/home/dir/somefile.d.ts                                                                      |                                                                                                          |           |
| //vda1cs4850/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/home/dir/subdir                                                                             | true      |
| //vda1cs4850/home/username/somefile.d.ts                                                                 |                                                                                                          |           |
| //vda1cs4850/home/username/dir/somefile.d.ts                                                             | //vda1cs4850/home/username/dir                                                                           | true      |
| //vda1cs4850/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/home/username/dir                                                                           | true      |
| //vda1cs4850/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |

## RootDirForResolution: //vda1cs4850/usr/username/folderAtRoot/folder1/folder2

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/somefile.d.ts                                                                               |                                                                                                          |           |
| //vda1cs4850/dir/somefile.d.ts                                                                           |                                                                                                          |           |
| //vda1cs4850/dir/subdir/somefile.d.ts                                                                    |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/somefile.d.ts                                                                  |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/dir/somefile.d.ts                                                              |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/folderAtRoot/dir/subdir                                                                     | true      |
| //vda1cs4850/folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/folder1/dir/somefile.d.ts                                                      | //vda1cs4850/folderAtRoot/folder1/dir                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/folderAtRoot/folder1/dir                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/users/somefile.d.ts                                                                         |                                                                                                          |           |
| //vda1cs4850/users/dir/somefile.d.ts                                                                     |                                                                                                          |           |
| //vda1cs4850/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/users/dir/subdir                                                                            | true      |
| //vda1cs4850/users/username/somefile.d.ts                                                                |                                                                                                          |           |
| //vda1cs4850/users/username/dir/somefile.d.ts                                                            | //vda1cs4850/users/username/dir                                                                          | true      |
| //vda1cs4850/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/users/username/dir                                                                          | true      |
| //vda1cs4850/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/dir/somefile.d.ts                                               | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/user/somefile.d.ts                                                                          |                                                                                                          |           |
| //vda1cs4850/user/dir/somefile.d.ts                                                                      |                                                                                                          |           |
| //vda1cs4850/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/user/dir/subdir                                                                             | true      |
| //vda1cs4850/user/username/somefile.d.ts                                                                 |                                                                                                          |           |
| //vda1cs4850/user/username/dir/somefile.d.ts                                                             | //vda1cs4850/user/username/dir                                                                           | true      |
| //vda1cs4850/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/user/username/dir                                                                           | true      |
| //vda1cs4850/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/usr/somefile.d.ts                                                                           |                                                                                                          |           |
| //vda1cs4850/usr/dir/somefile.d.ts                                                                       |                                                                                                          |           |
| //vda1cs4850/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/usr/dir/subdir                                                                              | true      |
| //vda1cs4850/usr/username/somefile.d.ts                                                                  |                                                                                                          |           |
| //vda1cs4850/usr/username/dir/somefile.d.ts                                                              | //vda1cs4850/usr/username/dir                                                                            | true      |
| //vda1cs4850/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/usr/username/dir                                                                            | true      |
| //vda1cs4850/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | false     |
| //vda1cs4850/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | //vda1cs4850/usr/username/folderAtRoot/dir                                                               | true      |
| //vda1cs4850/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot/dir                                                               | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot/folder1                                                           | false     |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | //vda1cs4850/usr/username/folderAtRoot/folder1/dir                                                       | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot/folder1/dir                                                       | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2                                                   | false     |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir                                               | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir                                               | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3                                           | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3                                           | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3                                           | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3                                           | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3                                           | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3                                           | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3                                           | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3                                           | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3                                           | true      |
| //vda1cs4850/home/somefile.d.ts                                                                          |                                                                                                          |           |
| //vda1cs4850/home/dir/somefile.d.ts                                                                      |                                                                                                          |           |
| //vda1cs4850/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/home/dir/subdir                                                                             | true      |
| //vda1cs4850/home/username/somefile.d.ts                                                                 |                                                                                                          |           |
| //vda1cs4850/home/username/dir/somefile.d.ts                                                             | //vda1cs4850/home/username/dir                                                                           | true      |
| //vda1cs4850/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/home/username/dir                                                                           | true      |
| //vda1cs4850/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |

## RootDirForResolution: //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/somefile.d.ts                                                                               |                                                                                                          |           |
| //vda1cs4850/dir/somefile.d.ts                                                                           |                                                                                                          |           |
| //vda1cs4850/dir/subdir/somefile.d.ts                                                                    |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/somefile.d.ts                                                                  |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/dir/somefile.d.ts                                                              |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/folderAtRoot/dir/subdir                                                                     | true      |
| //vda1cs4850/folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/folder1/dir/somefile.d.ts                                                      | //vda1cs4850/folderAtRoot/folder1/dir                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/folderAtRoot/folder1/dir                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/users/somefile.d.ts                                                                         |                                                                                                          |           |
| //vda1cs4850/users/dir/somefile.d.ts                                                                     |                                                                                                          |           |
| //vda1cs4850/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/users/dir/subdir                                                                            | true      |
| //vda1cs4850/users/username/somefile.d.ts                                                                |                                                                                                          |           |
| //vda1cs4850/users/username/dir/somefile.d.ts                                                            | //vda1cs4850/users/username/dir                                                                          | true      |
| //vda1cs4850/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/users/username/dir                                                                          | true      |
| //vda1cs4850/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/dir/somefile.d.ts                                               | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/user/somefile.d.ts                                                                          |                                                                                                          |           |
| //vda1cs4850/user/dir/somefile.d.ts                                                                      |                                                                                                          |           |
| //vda1cs4850/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/user/dir/subdir                                                                             | true      |
| //vda1cs4850/user/username/somefile.d.ts                                                                 |                                                                                                          |           |
| //vda1cs4850/user/username/dir/somefile.d.ts                                                             | //vda1cs4850/user/username/dir                                                                           | true      |
| //vda1cs4850/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/user/username/dir                                                                           | true      |
| //vda1cs4850/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/usr/somefile.d.ts                                                                           |                                                                                                          |           |
| //vda1cs4850/usr/dir/somefile.d.ts                                                                       |                                                                                                          |           |
| //vda1cs4850/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/usr/dir/subdir                                                                              | true      |
| //vda1cs4850/usr/username/somefile.d.ts                                                                  |                                                                                                          |           |
| //vda1cs4850/usr/username/dir/somefile.d.ts                                                              | //vda1cs4850/usr/username/dir                                                                            | true      |
| //vda1cs4850/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/usr/username/dir                                                                            | true      |
| //vda1cs4850/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | false     |
| //vda1cs4850/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | //vda1cs4850/usr/username/folderAtRoot/dir                                                               | true      |
| //vda1cs4850/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot/dir                                                               | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot/folder1                                                           | false     |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | //vda1cs4850/usr/username/folderAtRoot/folder1/dir                                                       | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot/folder1/dir                                                       | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2                                                   | false     |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir                                               | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir                                               | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir                                       | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir                                       | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | true      |
| //vda1cs4850/home/somefile.d.ts                                                                          |                                                                                                          |           |
| //vda1cs4850/home/dir/somefile.d.ts                                                                      |                                                                                                          |           |
| //vda1cs4850/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/home/dir/subdir                                                                             | true      |
| //vda1cs4850/home/username/somefile.d.ts                                                                 |                                                                                                          |           |
| //vda1cs4850/home/username/dir/somefile.d.ts                                                             | //vda1cs4850/home/username/dir                                                                           | true      |
| //vda1cs4850/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/home/username/dir                                                                           | true      |
| //vda1cs4850/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |

## RootDirForResolution: //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/somefile.d.ts                                                                               |                                                                                                          |           |
| //vda1cs4850/dir/somefile.d.ts                                                                           |                                                                                                          |           |
| //vda1cs4850/dir/subdir/somefile.d.ts                                                                    |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/somefile.d.ts                                                                  |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/dir/somefile.d.ts                                                              |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/folderAtRoot/dir/subdir                                                                     | true      |
| //vda1cs4850/folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/folder1/dir/somefile.d.ts                                                      | //vda1cs4850/folderAtRoot/folder1/dir                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/folderAtRoot/folder1/dir                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/users/somefile.d.ts                                                                         |                                                                                                          |           |
| //vda1cs4850/users/dir/somefile.d.ts                                                                     |                                                                                                          |           |
| //vda1cs4850/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/users/dir/subdir                                                                            | true      |
| //vda1cs4850/users/username/somefile.d.ts                                                                |                                                                                                          |           |
| //vda1cs4850/users/username/dir/somefile.d.ts                                                            | //vda1cs4850/users/username/dir                                                                          | true      |
| //vda1cs4850/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/users/username/dir                                                                          | true      |
| //vda1cs4850/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/dir/somefile.d.ts                                               | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/user/somefile.d.ts                                                                          |                                                                                                          |           |
| //vda1cs4850/user/dir/somefile.d.ts                                                                      |                                                                                                          |           |
| //vda1cs4850/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/user/dir/subdir                                                                             | true      |
| //vda1cs4850/user/username/somefile.d.ts                                                                 |                                                                                                          |           |
| //vda1cs4850/user/username/dir/somefile.d.ts                                                             | //vda1cs4850/user/username/dir                                                                           | true      |
| //vda1cs4850/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/user/username/dir                                                                           | true      |
| //vda1cs4850/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/usr/somefile.d.ts                                                                           |                                                                                                          |           |
| //vda1cs4850/usr/dir/somefile.d.ts                                                                       |                                                                                                          |           |
| //vda1cs4850/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/usr/dir/subdir                                                                              | true      |
| //vda1cs4850/usr/username/somefile.d.ts                                                                  |                                                                                                          |           |
| //vda1cs4850/usr/username/dir/somefile.d.ts                                                              | //vda1cs4850/usr/username/dir                                                                            | true      |
| //vda1cs4850/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/usr/username/dir                                                                            | true      |
| //vda1cs4850/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | false     |
| //vda1cs4850/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | //vda1cs4850/usr/username/folderAtRoot/dir                                                               | true      |
| //vda1cs4850/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot/dir                                                               | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot/folder1                                                           | false     |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | //vda1cs4850/usr/username/folderAtRoot/folder1/dir                                                       | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot/folder1/dir                                                       | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2                                                   | false     |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir                                               | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir                                               | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir                                       | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir                                       | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                               | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                               | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | true      |
| //vda1cs4850/home/somefile.d.ts                                                                          |                                                                                                          |           |
| //vda1cs4850/home/dir/somefile.d.ts                                                                      |                                                                                                          |           |
| //vda1cs4850/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/home/dir/subdir                                                                             | true      |
| //vda1cs4850/home/username/somefile.d.ts                                                                 |                                                                                                          |           |
| //vda1cs4850/home/username/dir/somefile.d.ts                                                             | //vda1cs4850/home/username/dir                                                                           | true      |
| //vda1cs4850/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/home/username/dir                                                                           | true      |
| //vda1cs4850/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |

## RootDirForResolution: //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/somefile.d.ts                                                                               |                                                                                                          |           |
| //vda1cs4850/dir/somefile.d.ts                                                                           |                                                                                                          |           |
| //vda1cs4850/dir/subdir/somefile.d.ts                                                                    |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/somefile.d.ts                                                                  |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/dir/somefile.d.ts                                                              |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/folderAtRoot/dir/subdir                                                                     | true      |
| //vda1cs4850/folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/folder1/dir/somefile.d.ts                                                      | //vda1cs4850/folderAtRoot/folder1/dir                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/folderAtRoot/folder1/dir                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/users/somefile.d.ts                                                                         |                                                                                                          |           |
| //vda1cs4850/users/dir/somefile.d.ts                                                                     |                                                                                                          |           |
| //vda1cs4850/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/users/dir/subdir                                                                            | true      |
| //vda1cs4850/users/username/somefile.d.ts                                                                |                                                                                                          |           |
| //vda1cs4850/users/username/dir/somefile.d.ts                                                            | //vda1cs4850/users/username/dir                                                                          | true      |
| //vda1cs4850/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/users/username/dir                                                                          | true      |
| //vda1cs4850/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/dir/somefile.d.ts                                               | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/user/somefile.d.ts                                                                          |                                                                                                          |           |
| //vda1cs4850/user/dir/somefile.d.ts                                                                      |                                                                                                          |           |
| //vda1cs4850/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/user/dir/subdir                                                                             | true      |
| //vda1cs4850/user/username/somefile.d.ts                                                                 |                                                                                                          |           |
| //vda1cs4850/user/username/dir/somefile.d.ts                                                             | //vda1cs4850/user/username/dir                                                                           | true      |
| //vda1cs4850/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/user/username/dir                                                                           | true      |
| //vda1cs4850/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/usr/somefile.d.ts                                                                           |                                                                                                          |           |
| //vda1cs4850/usr/dir/somefile.d.ts                                                                       |                                                                                                          |           |
| //vda1cs4850/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/usr/dir/subdir                                                                              | true      |
| //vda1cs4850/usr/username/somefile.d.ts                                                                  |                                                                                                          |           |
| //vda1cs4850/usr/username/dir/somefile.d.ts                                                              | //vda1cs4850/usr/username/dir                                                                            | true      |
| //vda1cs4850/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/usr/username/dir                                                                            | true      |
| //vda1cs4850/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | false     |
| //vda1cs4850/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | //vda1cs4850/usr/username/folderAtRoot/dir                                                               | true      |
| //vda1cs4850/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot/dir                                                               | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot/folder1                                                           | false     |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | //vda1cs4850/usr/username/folderAtRoot/folder1/dir                                                       | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot/folder1/dir                                                       | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2                                                   | false     |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir                                               | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir                                               | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir                                       | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir                                       | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                               | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                               | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                       | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                       | true      |
| //vda1cs4850/home/somefile.d.ts                                                                          |                                                                                                          |           |
| //vda1cs4850/home/dir/somefile.d.ts                                                                      |                                                                                                          |           |
| //vda1cs4850/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/home/dir/subdir                                                                             | true      |
| //vda1cs4850/home/username/somefile.d.ts                                                                 |                                                                                                          |           |
| //vda1cs4850/home/username/dir/somefile.d.ts                                                             | //vda1cs4850/home/username/dir                                                                           | true      |
| //vda1cs4850/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/home/username/dir                                                                           | true      |
| //vda1cs4850/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |

## RootDirForResolution: //vda1cs4850/home

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/somefile.d.ts                                                                               |                                                                                                          |           |
| //vda1cs4850/dir/somefile.d.ts                                                                           |                                                                                                          |           |
| //vda1cs4850/dir/subdir/somefile.d.ts                                                                    |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/somefile.d.ts                                                                  |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/dir/somefile.d.ts                                                              |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/folderAtRoot/dir/subdir                                                                     | true      |
| //vda1cs4850/folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/folder1/dir/somefile.d.ts                                                      | //vda1cs4850/folderAtRoot/folder1/dir                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/folderAtRoot/folder1/dir                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/users/somefile.d.ts                                                                         |                                                                                                          |           |
| //vda1cs4850/users/dir/somefile.d.ts                                                                     |                                                                                                          |           |
| //vda1cs4850/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/users/dir/subdir                                                                            | true      |
| //vda1cs4850/users/username/somefile.d.ts                                                                |                                                                                                          |           |
| //vda1cs4850/users/username/dir/somefile.d.ts                                                            | //vda1cs4850/users/username/dir                                                                          | true      |
| //vda1cs4850/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/users/username/dir                                                                          | true      |
| //vda1cs4850/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/dir/somefile.d.ts                                               | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/user/somefile.d.ts                                                                          |                                                                                                          |           |
| //vda1cs4850/user/dir/somefile.d.ts                                                                      |                                                                                                          |           |
| //vda1cs4850/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/user/dir/subdir                                                                             | true      |
| //vda1cs4850/user/username/somefile.d.ts                                                                 |                                                                                                          |           |
| //vda1cs4850/user/username/dir/somefile.d.ts                                                             | //vda1cs4850/user/username/dir                                                                           | true      |
| //vda1cs4850/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/user/username/dir                                                                           | true      |
| //vda1cs4850/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/usr/somefile.d.ts                                                                           |                                                                                                          |           |
| //vda1cs4850/usr/dir/somefile.d.ts                                                                       |                                                                                                          |           |
| //vda1cs4850/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/usr/dir/subdir                                                                              | true      |
| //vda1cs4850/usr/username/somefile.d.ts                                                                  |                                                                                                          |           |
| //vda1cs4850/usr/username/dir/somefile.d.ts                                                              | //vda1cs4850/usr/username/dir                                                                            | true      |
| //vda1cs4850/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/usr/username/dir                                                                            | true      |
| //vda1cs4850/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/home/somefile.d.ts                                                                          |                                                                                                          |           |
| //vda1cs4850/home/dir/somefile.d.ts                                                                      |                                                                                                          |           |
| //vda1cs4850/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/home/dir/subdir                                                                             | true      |
| //vda1cs4850/home/username/somefile.d.ts                                                                 |                                                                                                          |           |
| //vda1cs4850/home/username/dir/somefile.d.ts                                                             | //vda1cs4850/home/username/dir                                                                           | true      |
| //vda1cs4850/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/home/username/dir                                                                           | true      |
| //vda1cs4850/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |

## RootDirForResolution: //vda1cs4850/home/username

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/somefile.d.ts                                                                               |                                                                                                          |           |
| //vda1cs4850/dir/somefile.d.ts                                                                           |                                                                                                          |           |
| //vda1cs4850/dir/subdir/somefile.d.ts                                                                    |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/somefile.d.ts                                                                  |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/dir/somefile.d.ts                                                              |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/folderAtRoot/dir/subdir                                                                     | true      |
| //vda1cs4850/folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/folder1/dir/somefile.d.ts                                                      | //vda1cs4850/folderAtRoot/folder1/dir                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/folderAtRoot/folder1/dir                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/users/somefile.d.ts                                                                         |                                                                                                          |           |
| //vda1cs4850/users/dir/somefile.d.ts                                                                     |                                                                                                          |           |
| //vda1cs4850/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/users/dir/subdir                                                                            | true      |
| //vda1cs4850/users/username/somefile.d.ts                                                                |                                                                                                          |           |
| //vda1cs4850/users/username/dir/somefile.d.ts                                                            | //vda1cs4850/users/username/dir                                                                          | true      |
| //vda1cs4850/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/users/username/dir                                                                          | true      |
| //vda1cs4850/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/dir/somefile.d.ts                                               | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/user/somefile.d.ts                                                                          |                                                                                                          |           |
| //vda1cs4850/user/dir/somefile.d.ts                                                                      |                                                                                                          |           |
| //vda1cs4850/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/user/dir/subdir                                                                             | true      |
| //vda1cs4850/user/username/somefile.d.ts                                                                 |                                                                                                          |           |
| //vda1cs4850/user/username/dir/somefile.d.ts                                                             | //vda1cs4850/user/username/dir                                                                           | true      |
| //vda1cs4850/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/user/username/dir                                                                           | true      |
| //vda1cs4850/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/usr/somefile.d.ts                                                                           |                                                                                                          |           |
| //vda1cs4850/usr/dir/somefile.d.ts                                                                       |                                                                                                          |           |
| //vda1cs4850/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/usr/dir/subdir                                                                              | true      |
| //vda1cs4850/usr/username/somefile.d.ts                                                                  |                                                                                                          |           |
| //vda1cs4850/usr/username/dir/somefile.d.ts                                                              | //vda1cs4850/usr/username/dir                                                                            | true      |
| //vda1cs4850/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/usr/username/dir                                                                            | true      |
| //vda1cs4850/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/home/somefile.d.ts                                                                          |                                                                                                          |           |
| //vda1cs4850/home/dir/somefile.d.ts                                                                      |                                                                                                          |           |
| //vda1cs4850/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/home/dir/subdir                                                                             | true      |
| //vda1cs4850/home/username/somefile.d.ts                                                                 |                                                                                                          |           |
| //vda1cs4850/home/username/dir/somefile.d.ts                                                             | //vda1cs4850/home/username/dir                                                                           | true      |
| //vda1cs4850/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/home/username/dir                                                                           | true      |
| //vda1cs4850/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot                                                                  | true      |

## RootDirForResolution: //vda1cs4850/home/username/folderAtRoot

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/somefile.d.ts                                                                               |                                                                                                          |           |
| //vda1cs4850/dir/somefile.d.ts                                                                           |                                                                                                          |           |
| //vda1cs4850/dir/subdir/somefile.d.ts                                                                    |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/somefile.d.ts                                                                  |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/dir/somefile.d.ts                                                              |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/folderAtRoot/dir/subdir                                                                     | true      |
| //vda1cs4850/folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/folder1/dir/somefile.d.ts                                                      | //vda1cs4850/folderAtRoot/folder1/dir                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/folderAtRoot/folder1/dir                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/users/somefile.d.ts                                                                         |                                                                                                          |           |
| //vda1cs4850/users/dir/somefile.d.ts                                                                     |                                                                                                          |           |
| //vda1cs4850/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/users/dir/subdir                                                                            | true      |
| //vda1cs4850/users/username/somefile.d.ts                                                                |                                                                                                          |           |
| //vda1cs4850/users/username/dir/somefile.d.ts                                                            | //vda1cs4850/users/username/dir                                                                          | true      |
| //vda1cs4850/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/users/username/dir                                                                          | true      |
| //vda1cs4850/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/dir/somefile.d.ts                                               | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/user/somefile.d.ts                                                                          |                                                                                                          |           |
| //vda1cs4850/user/dir/somefile.d.ts                                                                      |                                                                                                          |           |
| //vda1cs4850/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/user/dir/subdir                                                                             | true      |
| //vda1cs4850/user/username/somefile.d.ts                                                                 |                                                                                                          |           |
| //vda1cs4850/user/username/dir/somefile.d.ts                                                             | //vda1cs4850/user/username/dir                                                                           | true      |
| //vda1cs4850/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/user/username/dir                                                                           | true      |
| //vda1cs4850/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/usr/somefile.d.ts                                                                           |                                                                                                          |           |
| //vda1cs4850/usr/dir/somefile.d.ts                                                                       |                                                                                                          |           |
| //vda1cs4850/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/usr/dir/subdir                                                                              | true      |
| //vda1cs4850/usr/username/somefile.d.ts                                                                  |                                                                                                          |           |
| //vda1cs4850/usr/username/dir/somefile.d.ts                                                              | //vda1cs4850/usr/username/dir                                                                            | true      |
| //vda1cs4850/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/usr/username/dir                                                                            | true      |
| //vda1cs4850/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/home/somefile.d.ts                                                                          |                                                                                                          |           |
| //vda1cs4850/home/dir/somefile.d.ts                                                                      |                                                                                                          |           |
| //vda1cs4850/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/home/dir/subdir                                                                             | true      |
| //vda1cs4850/home/username/somefile.d.ts                                                                 |                                                                                                          |           |
| //vda1cs4850/home/username/dir/somefile.d.ts                                                             | //vda1cs4850/home/username/dir                                                                           | true      |
| //vda1cs4850/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/home/username/dir                                                                           | true      |
| //vda1cs4850/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | false     |
| //vda1cs4850/home/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/home/username/folderAtRoot/dir                                                              | true      |
| //vda1cs4850/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot/dir                                                              | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot/folder1                                                          | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/home/username/folderAtRoot/folder1                                                          | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot/folder1                                                          | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot/folder1                                                          | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/home/username/folderAtRoot/folder1                                                          | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot/folder1                                                          | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot/folder1                                                          | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/home/username/folderAtRoot/folder1                                                          | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot/folder1                                                          | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot/folder1                                                          | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/home/username/folderAtRoot/folder1                                                          | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot/folder1                                                          | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot/folder1                                                          | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/home/username/folderAtRoot/folder1                                                          | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot/folder1                                                          | true      |

## RootDirForResolution: //vda1cs4850/home/username/folderAtRoot/folder1

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/somefile.d.ts                                                                               |                                                                                                          |           |
| //vda1cs4850/dir/somefile.d.ts                                                                           |                                                                                                          |           |
| //vda1cs4850/dir/subdir/somefile.d.ts                                                                    |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/somefile.d.ts                                                                  |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/dir/somefile.d.ts                                                              |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/folderAtRoot/dir/subdir                                                                     | true      |
| //vda1cs4850/folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/folder1/dir/somefile.d.ts                                                      | //vda1cs4850/folderAtRoot/folder1/dir                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/folderAtRoot/folder1/dir                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/users/somefile.d.ts                                                                         |                                                                                                          |           |
| //vda1cs4850/users/dir/somefile.d.ts                                                                     |                                                                                                          |           |
| //vda1cs4850/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/users/dir/subdir                                                                            | true      |
| //vda1cs4850/users/username/somefile.d.ts                                                                |                                                                                                          |           |
| //vda1cs4850/users/username/dir/somefile.d.ts                                                            | //vda1cs4850/users/username/dir                                                                          | true      |
| //vda1cs4850/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/users/username/dir                                                                          | true      |
| //vda1cs4850/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/dir/somefile.d.ts                                               | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/user/somefile.d.ts                                                                          |                                                                                                          |           |
| //vda1cs4850/user/dir/somefile.d.ts                                                                      |                                                                                                          |           |
| //vda1cs4850/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/user/dir/subdir                                                                             | true      |
| //vda1cs4850/user/username/somefile.d.ts                                                                 |                                                                                                          |           |
| //vda1cs4850/user/username/dir/somefile.d.ts                                                             | //vda1cs4850/user/username/dir                                                                           | true      |
| //vda1cs4850/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/user/username/dir                                                                           | true      |
| //vda1cs4850/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/usr/somefile.d.ts                                                                           |                                                                                                          |           |
| //vda1cs4850/usr/dir/somefile.d.ts                                                                       |                                                                                                          |           |
| //vda1cs4850/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/usr/dir/subdir                                                                              | true      |
| //vda1cs4850/usr/username/somefile.d.ts                                                                  |                                                                                                          |           |
| //vda1cs4850/usr/username/dir/somefile.d.ts                                                              | //vda1cs4850/usr/username/dir                                                                            | true      |
| //vda1cs4850/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/usr/username/dir                                                                            | true      |
| //vda1cs4850/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/home/somefile.d.ts                                                                          |                                                                                                          |           |
| //vda1cs4850/home/dir/somefile.d.ts                                                                      |                                                                                                          |           |
| //vda1cs4850/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/home/dir/subdir                                                                             | true      |
| //vda1cs4850/home/username/somefile.d.ts                                                                 |                                                                                                          |           |
| //vda1cs4850/home/username/dir/somefile.d.ts                                                             | //vda1cs4850/home/username/dir                                                                           | true      |
| //vda1cs4850/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/home/username/dir                                                                           | true      |
| //vda1cs4850/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | false     |
| //vda1cs4850/home/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/home/username/folderAtRoot/dir                                                              | true      |
| //vda1cs4850/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot/dir                                                              | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot/folder1                                                          | false     |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/home/username/folderAtRoot/folder1/dir                                                      | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot/folder1/dir                                                      | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/home/username/folderAtRoot/folder1/folder2                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/home/username/folderAtRoot/folder1/folder2                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot/folder1/folder2                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/home/username/folderAtRoot/folder1/folder2                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/home/username/folderAtRoot/folder1/folder2                                                  | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot/folder1/folder2                                                  | true      |

## RootDirForResolution: //vda1cs4850/home/username/folderAtRoot/folder1/folder2

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/somefile.d.ts                                                                               |                                                                                                          |           |
| //vda1cs4850/dir/somefile.d.ts                                                                           |                                                                                                          |           |
| //vda1cs4850/dir/subdir/somefile.d.ts                                                                    |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/somefile.d.ts                                                                  |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/dir/somefile.d.ts                                                              |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/folderAtRoot/dir/subdir                                                                     | true      |
| //vda1cs4850/folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/folder1/dir/somefile.d.ts                                                      | //vda1cs4850/folderAtRoot/folder1/dir                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/folderAtRoot/folder1/dir                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/users/somefile.d.ts                                                                         |                                                                                                          |           |
| //vda1cs4850/users/dir/somefile.d.ts                                                                     |                                                                                                          |           |
| //vda1cs4850/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/users/dir/subdir                                                                            | true      |
| //vda1cs4850/users/username/somefile.d.ts                                                                |                                                                                                          |           |
| //vda1cs4850/users/username/dir/somefile.d.ts                                                            | //vda1cs4850/users/username/dir                                                                          | true      |
| //vda1cs4850/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/users/username/dir                                                                          | true      |
| //vda1cs4850/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/dir/somefile.d.ts                                               | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/user/somefile.d.ts                                                                          |                                                                                                          |           |
| //vda1cs4850/user/dir/somefile.d.ts                                                                      |                                                                                                          |           |
| //vda1cs4850/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/user/dir/subdir                                                                             | true      |
| //vda1cs4850/user/username/somefile.d.ts                                                                 |                                                                                                          |           |
| //vda1cs4850/user/username/dir/somefile.d.ts                                                             | //vda1cs4850/user/username/dir                                                                           | true      |
| //vda1cs4850/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/user/username/dir                                                                           | true      |
| //vda1cs4850/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/usr/somefile.d.ts                                                                           |                                                                                                          |           |
| //vda1cs4850/usr/dir/somefile.d.ts                                                                       |                                                                                                          |           |
| //vda1cs4850/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/usr/dir/subdir                                                                              | true      |
| //vda1cs4850/usr/username/somefile.d.ts                                                                  |                                                                                                          |           |
| //vda1cs4850/usr/username/dir/somefile.d.ts                                                              | //vda1cs4850/usr/username/dir                                                                            | true      |
| //vda1cs4850/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/usr/username/dir                                                                            | true      |
| //vda1cs4850/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/home/somefile.d.ts                                                                          |                                                                                                          |           |
| //vda1cs4850/home/dir/somefile.d.ts                                                                      |                                                                                                          |           |
| //vda1cs4850/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/home/dir/subdir                                                                             | true      |
| //vda1cs4850/home/username/somefile.d.ts                                                                 |                                                                                                          |           |
| //vda1cs4850/home/username/dir/somefile.d.ts                                                             | //vda1cs4850/home/username/dir                                                                           | true      |
| //vda1cs4850/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/home/username/dir                                                                           | true      |
| //vda1cs4850/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot                                                                  | false     |
| //vda1cs4850/home/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/home/username/folderAtRoot/dir                                                              | true      |
| //vda1cs4850/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot/dir                                                              | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot/folder1                                                          | false     |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/home/username/folderAtRoot/folder1/dir                                                      | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot/folder1/dir                                                      | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2                                                  | false     |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir                                              | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir                                              | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3                                          | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3                                          | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3                                          | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3                                          | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3                                          | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3                                          | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3                                          | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3                                          | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3                                          | true      |

## RootDirForResolution: //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/somefile.d.ts                                                                               |                                                                                                          |           |
| //vda1cs4850/dir/somefile.d.ts                                                                           |                                                                                                          |           |
| //vda1cs4850/dir/subdir/somefile.d.ts                                                                    |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/somefile.d.ts                                                                  |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/dir/somefile.d.ts                                                              |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/folderAtRoot/dir/subdir                                                                     | true      |
| //vda1cs4850/folderAtRoot/folder1/somefile.d.ts                                                          |                                                                                                          |           |
| //vda1cs4850/folderAtRoot/folder1/dir/somefile.d.ts                                                      | //vda1cs4850/folderAtRoot/folder1/dir                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/folderAtRoot/folder1/dir                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/users/somefile.d.ts                                                                         |                                                                                                          |           |
| //vda1cs4850/users/dir/somefile.d.ts                                                                     |                                                                                                          |           |
| //vda1cs4850/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/users/dir/subdir                                                                            | true      |
| //vda1cs4850/users/username/somefile.d.ts                                                                |                                                                                                          |           |
| //vda1cs4850/users/username/dir/somefile.d.ts                                                            | //vda1cs4850/users/username/dir                                                                          | true      |
| //vda1cs4850/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/users/username/dir                                                                          | true      |
| //vda1cs4850/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/dir/somefile.d.ts                                               | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/user/somefile.d.ts                                                                          |                                                                                                          |           |
| //vda1cs4850/user/dir/somefile.d.ts                                                                      |                                                                                                          |           |
| //vda1cs4850/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/user/dir/subdir                                                                             | true      |
| //vda1cs4850/user/username/somefile.d.ts                                                                 |                                                                                                          |           |
| //vda1cs4850/user/username/dir/somefile.d.ts                                                             | //vda1cs4850/user/username/dir                                                                           | true      |
| //vda1cs4850/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/user/username/dir                                                                           | true      |
| //vda1cs4850/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/usr/somefile.d.ts                                                                           |                                                                                                          |           |
| //vda1cs4850/usr/dir/somefile.d.ts                                                                       |                                                                                                          |           |
| //vda1cs4850/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/usr/dir/subdir                                                                              | true      |
| //vda1cs4850/usr/username/somefile.d.ts                                                                  |                                                                                                          |           |
| //vda1cs4850/usr/username/dir/somefile.d.ts                                                              | //vda1cs4850/usr/username/dir                                                                            | true      |
| //vda1cs4850/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/usr/username/dir                                                                            | true      |
| //vda1cs4850/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | //vda1cs4850/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs