/**
 * Copyright (c) Tiny Technologies, Inc. All rights reserved.
 * Licensed under the LGPL or a commercial license.
 * For LGPL see License.txt in the project root for license information.
 * For commercial licenses see https://www.tiny.cloud/
 */

import { Arr } from '@ephox/katamari';
import { Compare, Replication, SugarElement, Traverse } from '@ephox/sugar';
import Editor from 'tinymce/core/api/Editor';
import { Indentation } from '../listmodel/Indentation';
import * as SplitList from './SplitList';

const outdentDlItem = (editor: Editor, item: SugarElement): void => {
  if (Compare.is(item, 'dd')) {
    Replication.mutate(item, 'dt');
  } else if (Compare.is(item, 'dt')) {
    Traverse.parent(item).each((dl) => SplitList.splitList(editor, dl.dom, item.dom));
  }
};

const indentDlItem = (item: SugarElement): void => {
  if (Compare.is(item, 'dt')) {
    Replication.mutate(item, 'dd');
  }
};

const dlIndentation = (editor: Editor, indentation: Indentation, dlItems: SugarElement[]) => {
  if (indentation === Indentation.Indent) {
    Arr.each(dlItems, indentDlItem);
  } else {
    Arr.each(dlItems, (item) => outdentDlItem(editor, item));
  }
};

export {
  dlIndentation
};
